/* module-TrueTime_VMESG2.cc */
/* Created by Dennis Murphree on 18 Jan 2001. */
/* Last updated by Enomoto Sanshiro on 14 January 2002. */


#include "RoomDeviceFactory.hh"
#include "RoomVmeAccess.hh"
#include "module-TrueTime_VMESG2.hh"

using namespace std;


static TRoomVmeModuleCreator Creator(
    "TrueTime_VMESG2", new TVmeTimingGenerator_TrueTime_VMESG2()
);


TVmeTimingGenerator_TrueTime_VMESG2::TVmeTimingGenerator_TrueTime_VMESG2(void)
: TRoomVmeModule("VmeTimingGenerator", "TrueTime_VMESG2", (TRoomVmeTransferMode) TransferMode_TrueTime_VMESG2, (size_t) MapSize_TrueTime_VMESG2)
{
}

TVmeTimingGenerator_TrueTime_VMESG2::~TVmeTimingGenerator_TrueTime_VMESG2()
{
}

TRoomVmeModule* TVmeTimingGenerator_TrueTime_VMESG2::Clone(void) 
{
    return new TVmeTimingGenerator_TrueTime_VMESG2();
}

int TVmeTimingGenerator_TrueTime_VMESG2::Initialize(int InitialState) throw(THardwareException)
{
    int SelfTestWord;
    ReadRegister(reg_SelfTest, SelfTestWord);
    if (SelfTestWord & 0xff != 0) {
        throw THardwareException(
            "TVmeTimingGenerator_TrueTime_VMESG2::Initialize()", 
            "self test failed"
        );
    }

    WriteRegister(reg_InterruptControl0, 0x00);
    WriteRegister(reg_Config1, OperationMode_CodeSyncronized | bit_InterruptEnableOnConfigRegister);
    WriteRegister(reg_Config2, bit_IRIGB_Format_DC);
    
    ClearExtEventInterrupt();
    Enable();

    return 1;
}

int TVmeTimingGenerator_TrueTime_VMESG2::Finalize(int FinalState) throw(THardwareException)
{
    return 1;
}

int TVmeTimingGenerator_TrueTime_VMESG2::Enable(int Address) throw(THardwareException)
{
    ReleaseTime();
    ReleaseExtEventTime();

    return 1;
}

int TVmeTimingGenerator_TrueTime_VMESG2::Disable(int Address) throw(THardwareException)
{
    FreezeTime();

    return 1;
}

int TVmeTimingGenerator_TrueTime_VMESG2::Clear(int Address) throw(THardwareException)
{
    ReleaseTime();
    ReleaseExtEventTime();

    return 1;
}

int TVmeTimingGenerator_TrueTime_VMESG2::Read(int Address, int &Data) throw(THardwareException)
{
    switch (Address) {
      case 0:
	  Data = ReadExtEventMicroSeconds();
	  break;
      case 1:
	  Data = ReadExtEventMilliSeconds();
	  break;
      case 2:
	  Data = ReadExtEventSeconds();
	  break;
      case 3:
	  Data = ReadExtEventMinutes();
	  break;
      case 4:
	  Data = ReadExtEventHours();
	  break;
      case 5:
	  Data = ReadExtEventDays();
	  break;
      case 6:
	  Data = ReadExtEventYears();
	  break;
      case 7:
	  Data = ReadExtEventStatus();
	  break;
      default:
	  return 0;
    }

    return 1;
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadRegister(int Address, int& Data) throw(THardwareException) 
{
    Data = GetWord(Address);
    Suspend(0, 1000);

    return 1;
}

int TVmeTimingGenerator_TrueTime_VMESG2::WriteRegister(int Address, int Data) throw(THardwareException) 
{
    PutWord(Address, Data);
    Suspend(0, 1000);

    return 1;
}

int TVmeTimingGenerator_TrueTime_VMESG2::EnableInterrupt(int SignalId) throw(THardwareException)
{
    TRoomVmeModule::EnableInterrupt(SignalId);

    int Irq = VmeAccessProperty()->InterruptNumber;
    int Vector = VmeAccessProperty()->InterruptVector;
    EnableExtEventInterrupt(Irq, Vector);

    ClearExtEventInterrupt();

    return 1;
}

int TVmeTimingGenerator_TrueTime_VMESG2::DisableInterrupt(void) throw(THardwareException)
{
    DisableExtEventInterrupt();
    TRoomVmeModule::DisableInterrupt();

    return 1;
}

int TVmeTimingGenerator_TrueTime_VMESG2::ClearInterrupt(void) throw(THardwareException)
{
    ClearExtEventInterrupt();
    return 1;
}

void TVmeTimingGenerator_TrueTime_VMESG2::EnableServiceRequest(void) throw(THardwareException)
{
    EnableInterrupt(0);
}

void TVmeTimingGenerator_TrueTime_VMESG2::DisableServiceRequest(void) throw(THardwareException)
{
    DisableInterrupt();
}

void TVmeTimingGenerator_TrueTime_VMESG2::ClearServiceRequest(void) throw(THardwareException)
{
    ClearInterrupt();
}

bool TVmeTimingGenerator_TrueTime_VMESG2::IsRequestingService(void) throw(THardwareException)
{
    return IsExtEventTimeFrozen();
}

void TVmeTimingGenerator_TrueTime_VMESG2::FreezeTime(void) 
{
    int Value;
    ReadRegister(reg_CaptureTime, Value);

    _DummyVariableToAvoidCompilerOptimization = Value;
}

void TVmeTimingGenerator_TrueTime_VMESG2::ReleaseTime(void) 
{
    int Value;
    ReadRegister(reg_ReleaseTime, Value);

    _DummyVariableToAvoidCompilerOptimization = Value;
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadMicroSeconds(void) 
{
    int TimeWord1;
    ReadRegister(reg_TimeWordOne, TimeWord1);

    int Hunds = ((TimeWord1 >> shift_HMicSecs) & 0x000f);
    int Tens = ((TimeWord1 >> shift_TMicSecs) & 0x000f);
    int Units = ((TimeWord1 >> shift_UMicSecs) & 0x000f);

    return (100 * Hunds + 10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadMilliSeconds(void) 
{
    int TimeWord1, TimeWord2;
    ReadRegister(reg_TimeWordOne, TimeWord1);
    ReadRegister(reg_TimeWordTwo, TimeWord2);

    int Hunds = ((TimeWord2 >> shift_HMSecs) & 0x000f);
    int Tens = ((TimeWord2 >> shift_TMSecs) & 0x000f);
    int Units = ((TimeWord1 >> shift_UMSecs) & 0x000f);

    return (100 * Hunds + 10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadSeconds(void) 
{
    int TimeWord2;
    ReadRegister(reg_TimeWordTwo, TimeWord2);

    int Tens = ((TimeWord2 >> shift_TSecs) & 0x000f);
    int Units = ((TimeWord2 >> shift_USecs) & 0x000f);

    return (10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadMinutes(void) 
{
    int TimeWord3;
    ReadRegister(reg_TimeWordThree, TimeWord3);

    int Tens = ((TimeWord3 >> shift_TMins) & 0x000f);
    int Units = ((TimeWord3 >> shift_UMins) & 0x000f);

    return (10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadHours(void) 
{
    int TimeWord3;
    ReadRegister(reg_TimeWordThree, TimeWord3);

    int Tens = ((TimeWord3 >> shift_THours) & 0x000f);
    int Units = ((TimeWord3 >> shift_UHours) & 0x000f);

    return (10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadDays(void) 
{
    int TimeWord4;
    ReadRegister(reg_TimeWordFour, TimeWord4);

    int Hunds = ((TimeWord4 >> shift_HDays) & 0x000f);
    int Tens = ((TimeWord4 >> shift_TDays) & 0x000f);
    int Units = ((TimeWord4 >> shift_UDays) & 0x000f);    
    
    return (100 * Hunds + 10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadStatus(void) 
{
    int TimeWord4;
    ReadRegister(reg_TimeWordFour, TimeWord4);

    int Status = ((TimeWord4 >> shift_Status) & 0x000f);

    return Status;
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadYears(void) 
{
    int TimeWord5;
    ReadRegister(reg_TimeWordFive, TimeWord5);

    int Thous = ((TimeWord5 >> shift_ThYears) & 0x000f);
    int Hunds = ((TimeWord5 >> shift_HYears) & 0x000f);
    int Tens = ((TimeWord5 >> shift_TYears) & 0x000f);
    int Units = ((TimeWord5 >> shift_UYears) & 0x000f);

    return (1000 * Thous + 100 * Hunds + 10 * Tens + Units);
}

void TVmeTimingGenerator_TrueTime_VMESG2::EnableExtEventInterrupt(int Irq, int Vector)
{
    WriteRegister(reg_InterruptVector0, Vector);

    int Value;
    ReadRegister(reg_InterruptControl0, Value);
    Value |= bit_InterruptEnable | Irq;
    WriteRegister(reg_InterruptControl0, Value);
}

void TVmeTimingGenerator_TrueTime_VMESG2::DisableExtEventInterrupt(void)
{
    int Value;
    ReadRegister(reg_InterruptControl0, Value);
    Value  &= ~bit_InterruptEnableOnConfigRegister;
    WriteRegister(reg_InterruptControl0, Value);
}

void TVmeTimingGenerator_TrueTime_VMESG2::ClearExtEventInterrupt(void)
{
    int Value;
    ReadRegister(reg_InterruptControl0, Value);
    Value |= bit_InterruptFlagAutoClear | bit_InterruptFlag;
    WriteRegister(reg_InterruptControl0, Value);
}

bool TVmeTimingGenerator_TrueTime_VMESG2::IsExtEventTimeFrozen(void)
{
    int Value;
    ReadRegister(reg_InterruptControl0, Value);

    return (Value & bit_InterruptFlag) == 0;
}

void TVmeTimingGenerator_TrueTime_VMESG2::ReleaseExtEventTime(void)
{
    int Value;
    ReadRegister(reg_ExtEventReleaseTime, Value);

    _DummyVariableToAvoidCompilerOptimization = Value;
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadExtEventMicroSeconds(void) 
{
    int TimeWord1;
    ReadRegister(reg_ExtEventTimeWordOne, TimeWord1);

    int Hunds = ((TimeWord1 >> shift_HMicSecs) & 0x000f);
    int Tens = ((TimeWord1 >> shift_TMicSecs) & 0x000f);
    int Units = ((TimeWord1 >> shift_UMicSecs) & 0x000f);

    return (100 * Hunds + 10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadExtEventMilliSeconds(void) 
{
    int TimeWord1, TimeWord2;
    ReadRegister(reg_ExtEventTimeWordOne, TimeWord1);
    ReadRegister(reg_ExtEventTimeWordTwo, TimeWord2);

    int Hunds = ((TimeWord2 >> shift_HMSecs) & 0x000f);
    int Tens = ((TimeWord2 >> shift_TMSecs) & 0x000f);
    int Units = ((TimeWord1 >> shift_UMSecs) & 0x000f);

    return (100 * Hunds + 10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadExtEventSeconds(void) 
{
    int TimeWord2;
    ReadRegister(reg_ExtEventTimeWordTwo, TimeWord2);

    int Tens = ((TimeWord2 >> shift_TSecs) & 0x000f);
    int Units = ((TimeWord2 >> shift_USecs) & 0x000f);

    return (10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadExtEventMinutes(void) 
{
    int TimeWord3;
    ReadRegister(reg_ExtEventTimeWordThree, TimeWord3);

    int Tens = ((TimeWord3 >> shift_TMins) & 0x000f);
    int Units = ((TimeWord3 >> shift_UMins) & 0x000f);

    return (10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadExtEventHours(void)
{
    int TimeWord3;
    ReadRegister(reg_ExtEventTimeWordThree, TimeWord3);

    int Tens = ((TimeWord3 >> shift_THours) & 0x000f);
    int Units = ((TimeWord3 >> shift_UHours) & 0x000f);

    return (10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadExtEventDays(void)
{
    int TimeWord4;
    ReadRegister(reg_ExtEventTimeWordFour, TimeWord4);

    int Hunds = ((TimeWord4 >> shift_HDays) & 0x000f);
    int Tens = ((TimeWord4 >> shift_TDays) & 0x000f);
    int Units = ((TimeWord4 >> shift_UDays) & 0x000f);

    return (100 * Hunds + 10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadExtEventYears(void)
{
    int TimeWord5;
    ReadRegister(reg_ExtEventTimeWordFive, TimeWord5);

    int Thous = ((TimeWord5 >> shift_ThYears) & 0x000f);
    int Hunds = ((TimeWord5 >> shift_HYears) & 0x000f);
    int Tens = ((TimeWord5 >> shift_TYears) & 0x000f);
    int Units = ((TimeWord5 >> shift_UYears) & 0x000f);

    return (1000 * Thous + 100 * Hunds + 10 * Tens + Units);
}

int TVmeTimingGenerator_TrueTime_VMESG2::ReadExtEventStatus(void) 
{
    int TimeWord4;
    ReadRegister(reg_ExtEventTimeWordFour, TimeWord4);

    int Status = ((TimeWord4 >> shift_Status) & 0x000f);

    return Status;
}
