/* module-VMIC_5010.cc */
/* Created by Enomoto Sanshiro on 25 July 2001 */
/* Last updated by Enomoto Sanshiro on 25 July 2001. */


#include "RoomModule.hh"
#include "RoomVmeAccess.hh"
#include "RoomDeviceFactory.hh"
#include "module-VMIC_5010.hh"

using namespace std;


static TRoomVmeModuleCreator Creator1(
    "VMIC_5010", new TVmeInterrupter_VMIC_5010()
);

const off_t TVmeInterrupter_VMIC_5010::ControlRegisterOffset[] = {
    regInterruptControl_0,
    regInterruptControl_1,
    regInterruptControl_2,
    regInterruptControl_3,
    regInterruptControl_4,
    regInterruptControl_5,
    regInterruptControl_6,
    regInterruptControl_7,
    regGlobalInterruptControl_0,
    regGlobalInterruptControl_1,
    regGlobalInterruptControl_2,
    regGlobalInterruptControl_3,
    regGlobalInterruptControl_4,
    regGlobalInterruptControl_5,
    regGlobalInterruptControl_6,
    regGlobalInterruptControl_7
};

const off_t TVmeInterrupter_VMIC_5010::VectorRegisterOffset[] = {
    regInterruptVector_0,
    regInterruptVector_1,
    regInterruptVector_2,
    regInterruptVector_3,
    regInterruptVector_4,
    regInterruptVector_5,
    regInterruptVector_6,
    regInterruptVector_7,
    regGlobalInterruptVector_0,
    regGlobalInterruptVector_1,
    regGlobalInterruptVector_2,
    regGlobalInterruptVector_3,
    regGlobalInterruptVector_4,
    regGlobalInterruptVector_5,
    regGlobalInterruptVector_6,
    regGlobalInterruptVector_7
};



TVmeInterrupter_VMIC_5010::TVmeInterrupter_VMIC_5010(void)
: TRoomVmeModule("VmeInterrupter", "VMIC_5010", (TRoomVmeTransferMode) TransferMode_VMIC5010, (size_t) MapSize_VMIC5010)
{
    _IsInterruptSignalUsed = false;
}

TVmeInterrupter_VMIC_5010::~TVmeInterrupter_VMIC_5010()
{
}

TRoomVmeModule* TVmeInterrupter_VMIC_5010::Clone(void)
{
    return new TVmeInterrupter_VMIC_5010();
}

int TVmeInterrupter_VMIC_5010::Initialize(int InitialState) throw(THardwareException)
{
    PutWord(regBoardControl, 0x00);
    PutWord(regPolarityControl, 0x00);

    for (int Address = 0; Address < NumberOfChannels_VMIC5010; Address++) {
        PutWord(ControlRegisterOffset[Address], bitFlag);
    }

    return 0;
}

int TVmeInterrupter_VMIC_5010::Finalize(int FinalState) throw(THardwareException)
{
    for (int Address = 0; Address < NumberOfChannels_VMIC5010; Address++) {
        PutWord(ControlRegisterOffset[Address], 0x00);
    }

    return 0;
}

int TVmeInterrupter_VMIC_5010::Enable(int Address) throw(THardwareException)
{
    if (! _IsInterruptSignalUsed) {
	TRoomVmeModule::EnableInterrupt();
    }

    int Irq = VmeAccessProperty()->InterruptNumber;
    int Vector = VmeAccessProperty()->InterruptVector;
    int ControlBits = bitInterruptEnable | bitFlag | bitFlagAutoClear;

    Address = 0; //...
    PutWord(VectorRegisterOffset[Address], Vector);
    PutWord(ControlRegisterOffset[Address], ControlBits | Irq);
    PutWord(regFieldInputEnable, Bit(Address));

    return 1;
}

int TVmeInterrupter_VMIC_5010::Disable(int Address) throw(THardwareException)
{
    Address = 0; //...
    PutWord(ControlRegisterOffset[Address], 0);

    if (! _IsInterruptSignalUsed) {
	TRoomVmeModule::DisableInterrupt();
    }

    return 1;
}

int TVmeInterrupter_VMIC_5010::Clear(int Address) throw(THardwareException)
{
    int Result;
    static const int FlagControlBits = bitFlag | bitFlagAutoClear;
    if ((Address >= 0) && (Address < NumberOfChannels_VMIC5010)) {
        WordAt(ControlRegisterOffset[Address]) |= FlagControlBits;
	Result = 1;
    }
    else if (Address == -1) {
	Result = 0;
	for (int i = 0; i < NumberOfChannels_VMIC5010; i++) {
	    Result += Clear(i);
	}
    }
    else {
	return 0;
    }

    return Result;
}

int TVmeInterrupter_VMIC_5010::IsBusy(int Address) throw(THardwareException)
{
    int Result;
    if ((Address >= 0) && (Address < NumberOfChannels_VMIC5010)) {
	Result = ((GetWord(ControlRegisterOffset[Address]) & bitFlag) == 0);
    }
    else if (Address == -1) {
	Result = 0;
	for (int i = 0; i < NumberOfChannels_VMIC5010; i++) {
	    Result |= IsBusy(i);
	}
    }
    else {
	Result = 0;
    }

    return Result;
}

int TVmeInterrupter_VMIC_5010::EnableInterrupt(int SignalId) throw(THardwareException)
{
    TRoomVmeModule::EnableInterrupt(SignalId);
    _IsInterruptSignalUsed = true;

    return Enable(0);
}

int TVmeInterrupter_VMIC_5010::DisableInterrupt(void) throw(THardwareException)
{
    int Result = Disable(0);
    TRoomVmeModule::DisableInterrupt();
    _IsInterruptSignalUsed = false;

    return Result;
}

int TVmeInterrupter_VMIC_5010::ClearInterrupt(void) throw(THardwareException)
{
    return 1;
}

void TVmeInterrupter_VMIC_5010::EnableServiceRequest(void) throw(THardwareException)
{
    Enable(0);
}

void TVmeInterrupter_VMIC_5010::DisableServiceRequest(void) throw(THardwareException)
{
    Disable(0);
}

void TVmeInterrupter_VMIC_5010::ClearServiceRequest(void) throw(THardwareException)
{
    Clear(0);
}

bool TVmeInterrupter_VMIC_5010::IsRequestingService(void) throw(THardwareException)
{
    return IsBusy(0);
}
