/* camac-adc.cc */
/* Created by Enomoto Sanshiro on 12 May 1999. */
/* Last updated by Enomoto Sanshiro on 16 July 1999. */


#include <cstdlib>
#include <iostream>
#include <strstream>
#include <unistd.h>
#include "RoomDefs.hh"
#include "RoomCamacAccess.hh"
#include "RoomDeviceFactory.hh"

using namespace std;


// If your system does not handle interrupts, uncomment the next line.
// #define IRQ_IS_NOT_AVAILABLE


class TCamacAdc {
  public:
    TCamacAdc(void) throw(THardwareException);
    virtual ~TCamacAdc();
    virtual int Run(int NumberOfEvents) throw(THardwareException);
  private:
    TRoomCamacCrate* _Crate;
    TRoomCamacController* _Controller;
    TRoomCamacModule* _Adc;
};



TCamacAdc::TCamacAdc(void) throw(THardwareException)
{
    TRoomDeviceFactory* DeviceFactory = TRoomDeviceFactory::GetInstance();

    _Crate = DeviceFactory->CreateCamacCrate();
    _Controller = DeviceFactory->CreateCamacController();
    _Adc = DeviceFactory->CreateCamacModule("CAMAC_Standard");

    int StationNumber;
    _Controller->Initialize();
    _Crate->InstallController(_Controller);
    _Crate->Install(_Adc, StationNumber = 4);
}


TCamacAdc::~TCamacAdc()
{
    delete _Adc;
    delete _Controller;
    delete _Crate;
}


int TCamacAdc::Run(int NumberOfEvents) throw(THardwareException)
{
    int EventCount = 0;
    int Channel, Data, Q;

    while (EventCount < NumberOfEvents) {
        
#ifndef IRQ_IS_NOT_AVAILABLE
        if (_Adc->WaitData()) {
#else
        while (! _Adc->HasData()) {
	    usleep(10000);   /* 10 ms sleep */
        }{
#endif
            for (Channel = 0; Channel < _Adc->NumberOfChannels(); Channel++) {
                Q = _Adc->Read(Channel, Data);
                cout << Channel << ": ";
                cout << Data;
                cout << " (" << Q << ")" << endl;
            }
            
	    _Adc->Clear();
            EventCount++;
        }
    }
    
    return EventCount;
}


int main(int argc, char** argv)
{
    int NumberOfEvents;
    if ((argc < 2) || ((NumberOfEvents = atoi(argv[1])) < 1)) {
	cerr << "Usage: " << argv[0] << " #-of-events" << endl;
	return 0;
    }

    try {
        TCamacAdc().Run(NumberOfEvents);
    }
    catch (THardwareException &e) {
        cerr << "ERROR: " << e << endl;
	return EXIT_FAILURE;
    }

    return 0;
}
