/* Kinoko2dHistogramWriter.cc */
/* Created by Enomoto Sanshiro on 13 January 2001. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#include <string>
#include "Kasp2dHistogram.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "Kinoko2dHistogramWriter.hh"

using namespace std;


TKinoko2dHistogramWriter::TKinoko2dHistogramWriter(TKasp2dHistogram* Histogram, const string& SectionPathX, const TKinokoDataElementSpecifier& ElementSpecifierX, const string& SectionPathY, const TKinokoDataElementSpecifier& ElementSpecifierY)
{
    _Histogram = Histogram;
    _SectionPathX = SectionPathX;
    _SectionPathY = SectionPathY;
    _ElementSpecifierX = ElementSpecifierX;
    _ElementSpecifierY = ElementSpecifierY;

    _SectionIndexX = AddSection(SectionPathX);
    _SectionIndexY = AddSection(SectionPathY);

    _TargetName = "untitled";
}

TKinoko2dHistogramWriter::~TKinoko2dHistogramWriter()
{
}

void TKinoko2dHistogramWriter::Destroy(void)
{
    delete _Histogram;
}

void TKinoko2dHistogramWriter::Reset(void) throw(TKinokoException)
{
    _Histogram->Clear();
}

int TKinoko2dHistogramWriter::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    int Address, Data;

    if (SectionData->SectionIndex() == _SectionIndexX) {
	while (SectionData->GetNextOf(_ElementSpecifierX, Address, Data)) {
	    _XDataList.push_back(_ElementSpecifierX.ConvertData(Data));
	}
    }
    else if (SectionData->SectionIndex() == _SectionIndexY) {
	while (SectionData->GetNextOf(_ElementSpecifierY, Address, Data)) {
	    _YDataList.push_back(_ElementSpecifierY.ConvertData(Data));
	}
    }

    return 1;
}

int TKinoko2dHistogramWriter::ProcessTrailer(int TrailerValue) throw(TKinokoException)
{
    unsigned NumberOfData;
    if ((NumberOfData = _XDataList.size()) == _YDataList.size()) {
	for (unsigned i = 0; i < NumberOfData; i++) {
	    _Histogram->Fill(_XDataList[i], _YDataList[i]);
	}
    }

    _XDataList.erase(_XDataList.begin(), _XDataList.end());
    _YDataList.erase(_YDataList.begin(), _YDataList.end());

    return 1;
}

void TKinoko2dHistogramWriter::SetTargetName(const std::string& Name)
{
    _TargetName = Name;
}

void TKinoko2dHistogramWriter::Dump(ostream& os, const string& Indent)
{
    os << Indent << "Fill2dHistogram" << "\t" << _TargetName;
    os << ", \"" << _SectionPathX << "\", " << _ElementSpecifierX.AsString();
    os << ", \"" << _SectionPathY << "\", " << _ElementSpecifierY.AsString();
    os << endl;
}
