/* Kinoko2dHistogramWriter.hh */
/* Created by Enomoto Sanshiro on 13 January 2001. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#ifndef __Kinoko2dHistogramWriter_hh__
#define __Kinoko2dHistogramWriter_hh__


#include <string>
#include <vector>
#include "Kasp2dHistogram.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoHistogramWriter.hh"


class TKinoko2dHistogramWriter: public TKinokoSectionDataAnalyzer {
  public:
    TKinoko2dHistogramWriter(TKasp2dHistogram* Histogram, const std::string& SectionPathX, const TKinokoDataElementSpecifier& ElementSpecifierX, const std::string& SectionPathY, const TKinokoDataElementSpecifier& ElementSpecifierY);
    virtual ~TKinoko2dHistogramWriter();
    virtual void Destroy(void);
    virtual void Reset(void) throw(TKinokoException);
    virtual void SetTargetName(const std::string& Name);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
    virtual int ProcessTrailer(int TrailerValue) throw(TKinokoException);
  protected:
    TKasp2dHistogram* _Histogram;
    std::string _SectionPathX, _SectionPathY;
    int _SectionIndexX, _SectionIndexY;
    TKinokoDataElementSpecifier _ElementSpecifierX, _ElementSpecifierY;
    std::string _TargetName;
    std::vector<double> _XDataList;
    std::vector<double> _YDataList;
};


#endif
