/* KinokoAnalysisAction.cc */
/* Created by Enomoto Sanshiro on 24 June 2002. */
/* Last updated by Enomoto Sanshiro on 24 June 2002. */



#include <string>
#include <vector>
#include "KinokoDataAnalyzer.hh"
#include "KinokoPlatform.hh"
#include "KinokoAnalysisAction.hh"

using namespace std;


TKinokoAnalysisAction::TKinokoAnalysisAction(void)
{
}

TKinokoAnalysisAction::~TKinokoAnalysisAction()
{
}

int TKinokoAnalysisAction::ProcessDataPacket(void* DataPacket, TKinokoDataSource* DataSource, TKinokoDataSection* DataSection) throw(TKinokoException)
{
    Execute();
    return 1;
}

int TKinokoAnalysisAction::ProcessTrailerPacket(void* Packet, TKinokoDataSource* DataSource) throw(TKinokoException)
{
    return 1;
}



TKinokoAnalysisInvokeAction::TKinokoAnalysisInvokeAction(TKinokoEventEmitter* EventEmitter, const string& EventName, const vector<string>& EventArgumentList)
{
    _EventEmitter = EventEmitter;
    _EventName = EventName;
    _EventArgumentList = EventArgumentList;
}

TKinokoAnalysisInvokeAction::~TKinokoAnalysisInvokeAction()
{
}

void TKinokoAnalysisInvokeAction::Execute(void)
{
    _EventEmitter->EmitEvent(_EventName, _EventArgumentList);
}

void TKinokoAnalysisInvokeAction::Dump(std::ostream& os, const std::string& Indent)
{
    os << Indent << "Invoke  " << "\t" << _EventName;
    for (unsigned int i = 0; i < _EventArgumentList.size(); i++) {
	os << ", \"" << _EventArgumentList[i] << "\"";
    }
    os << dec << endl;
}
