/* KinokoAnalysisMessenger.hh */
/* Created by Enomoto Sanshiro on 31 December 2000. */
/* Last updated by Enomoto Sanshiro on 4 May 2002. */


#ifndef __KinokoAnalysisMessenger_hh__
#define __KinokoAnalysisMessenger_hh__


#include <string>
#include <vector>
#include "ParaPackage.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoDataChecker.hh"


class TKinokoDataElementMessenger: public TParaObjectPrototype {
  public:
    TKinokoDataElementMessenger(void);
    virtual ~TKinokoDataElementMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int DispatchMessage(const std::string& Message, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual TParaValue& EvaluateOperator(TParaOperator* Operator, TParaValue& LeftValue, TParaValue& RightValue, TParaSymbolTable* SymbolTable, TParaValue& Result) throw(TScriptException);
  protected:
    virtual int SetOffset(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual int SetFactor(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  public:
    virtual const std::string& SectionPath(void);
    virtual const TKinokoDataElementSpecifier& DataElementSpecifier(void);
  protected:
    std::string _SectionPath;
    TKinokoDataElementSpecifier _ElementSpecifier;
};


class TKinokoAnalysisConditionMessenger: public TParaObjectPrototype {
  public:
    TKinokoAnalysisConditionMessenger(void);
    virtual ~TKinokoAnalysisConditionMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual TParaValue& EvaluateOperator(TParaOperator* Operator, TParaValue& LeftValue, TParaValue& RightValue, TParaSymbolTable* SymbolTable, TParaValue& Result) throw(TScriptException);
    virtual TKinokoDataChecker* GetDataChecker(void) throw(TScriptException) = 0;
};


class TKinokoDataConditionMessenger: public TKinokoAnalysisConditionMessenger {
  public:
    TKinokoDataConditionMessenger(const std::string& OperatorSymbol, TKinokoDataElementMessenger* DataElementMessenger, long Parameter);
    virtual ~TKinokoDataConditionMessenger();
    virtual TKinokoDataChecker* GetDataChecker(void) throw(TScriptException);
  protected:
    std::string _OperatorSymbol;
    TKinokoDataElementMessenger* _DataElementMessenger;
    long _Parameter;
};


class TKinokoComplexAnalysisConditionMessenger: public TKinokoAnalysisConditionMessenger {
  public:
    TKinokoComplexAnalysisConditionMessenger(const std::string& OperatorSymbol, TKinokoAnalysisConditionMessenger* LeftCondition, TKinokoAnalysisConditionMessenger* RightCondition);
    virtual ~TKinokoComplexAnalysisConditionMessenger();
    virtual TKinokoDataChecker* GetDataChecker(void) throw(TScriptException);
  protected:
    std::string _OperatorSymbol;
    TKinokoAnalysisConditionMessenger* _LeftCondition;
    TKinokoAnalysisConditionMessenger* _RightCondition;
};


#endif
