/* KinokoAnalysisSequence.hh */
/* Created by Enomoto Sanshiro on 17 September 2001 */
/* Last updated by Enomoto Sanshiro on 17 September 2001. */


#ifndef __KinokoAnalysisSequence_hh__
#define __KinokoAnalysisSequence_hh__


#include <iostream>
#include <string>
#include "KinokoDataAnalyzer.hh"
#include "KinokoDataChecker.hh"


class TKinokoAnalysisSequence: public TKinokoDataAnalyzerList {
  public:
    TKinokoAnalysisSequence(void);
    virtual ~TKinokoAnalysisSequence();
    virtual int ProcessTrailerPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  public:
    virtual void AddSequence(TKinokoAnalysisSequence* Sequence);
    virtual void Flush(void);
  protected:
    TKinokoAnalysisSequence** _SequenceList;
    int _NumberOfSequences;
    int _SequenceListCapacity;
};


class TKinokoSingleEventAnalysisSequence: public TKinokoAnalysisSequence {
  public:
    TKinokoSingleEventAnalysisSequence(void);
    virtual ~TKinokoSingleEventAnalysisSequence();
    virtual int ProcessDataPacket(void* DataPacket, TKinokoDataSource* DataSource = 0, TKinokoDataSection* DataSection = 0) throw(TKinokoException);
    virtual int ProcessTrailerPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  public:
    virtual void Flush(void);
  protected:
    enum TProcessorState {
        ProcessorState_WaitingNewEvent,
        ProcessorState_ReadingData,
        ProcessorState_HoldingData,
	_NumberOfProcessorStates
    };
    TProcessorState _ProcessorState;
    bool _IsLastEventCompleted;
};


class TKinokoConditionalAnalysisSequence: public TKinokoAnalysisSequence {
  public:
    TKinokoConditionalAnalysisSequence(TKinokoDataChecker* DataChecker);
    virtual ~TKinokoConditionalAnalysisSequence();
    virtual void ReadDataSource(TKinokoDataSource* DataSource) throw(TKinokoException);
    virtual int ProcessDataPacket(void* DataPacket, TKinokoDataSource* DataSource = 0, TKinokoDataSection* DataSection = 0) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoDataChecker* _DataChecker;
};


#endif
