/* KinokoCompositeDataProcessor.cc */
/* Created by Enomoto Sanshiro on 14 December 2002. */
/* Last updated by Enomoto Sanshiro on 14 December 2002. */


#include <string>
#include <vector>
#include "KinokoDataProcessor.hh"
#include "KinokoCompositeDataProcessor.hh"


TKinokoCompositeDataProcessor::TKinokoCompositeDataProcessor(void)
{
    _ProcessorListSize = 0;
    _ProcessorListCapacity = 16;
    
    _ProcessorList = new TKinokoDataProcessor* [_ProcessorListCapacity];
}

TKinokoCompositeDataProcessor::~TKinokoCompositeDataProcessor()
{
    delete[] _ProcessorList;
}

void TKinokoCompositeDataProcessor::AddDataProcessor(const std::string& Name, int DataSourceId, TKinokoDataProcessor* DataProcessor)
{
    _NameList.push_back(Name);
    _DataSourceIdList.push_back(DataSourceId);

    if (_ProcessorListSize >= _ProcessorListCapacity) {
	TKinokoDataProcessor** OldProcessorList = _ProcessorList;
	_ProcessorListCapacity *= 2;
	_ProcessorList = new TKinokoDataProcessor* [_ProcessorListCapacity];
	for (int i = 0; i < _ProcessorListSize; i++) {
	    _ProcessorList[i] = OldProcessorList[i];
	}
	delete[] OldProcessorList;
    }

    _ProcessorList[_ProcessorListSize] = DataProcessor;
    _ProcessorListSize++;
}

void TKinokoCompositeDataProcessor::Destroy(void)
{
    for (int i = 0; i < _ProcessorListSize; i++) {
	delete _ProcessorList[i];
    }
}

void TKinokoCompositeDataProcessor::AttachIO(std::istream& InputIoStream, std::ostream& OutputIoStream, TKinokoLogger* Logger)
{
    for (int i = 0; i < _ProcessorListSize; i++) {
	_ProcessorList[i]->AttachIO(InputIoStream, OutputIoStream, Logger);
    }
}

void TKinokoCompositeDataProcessor::Construct(const std::string& Name, TKinokoInputStream* InputStream, TKinokoOutputStream* OutputStream, int DataSourceId) throw(TKinokoException)
{
    ConstructInlet(InputStream);

    for (int i = 0; i < _ProcessorListSize; i++) {
	_ProcessorList[i]->Construct(
	    _NameList[i], InputStream, OutputStream, _DataSourceIdList[i]
	);
    }
}

void TKinokoCompositeDataProcessor::Destruct(void) throw(TKinokoException)
{
    for (int i = 0; i < _ProcessorListSize; i++) {
	_ProcessorList[i]->Destruct();
    }
}

void TKinokoCompositeDataProcessor::ProcessPacket(void* DataPacket, long PacketSize) throw(TKinokoException)
{
    for (int i = 0; i < _ProcessorListSize; i++) {
	_ProcessorList[i]->ProcessPacket(DataPacket, PacketSize);
    }
}

void TKinokoCompositeDataProcessor::BuildDataSource(TKinokoDataSource* DataSource)
{
}
