/* KinokoDataAnalyzer.hh */
/* Created by Enomoto Sanshiro on 23 October 1999. */
/* Last updated by Enomoto Sanshiro on 2 September 2001. */


#ifndef __KinokoDataAnalyzer_hh__
#define __KinokoDataAnalyzer_hh__


#include "KinokoDataSource.hh"
#include "KinokoDataSection.hh"
#include "KinokoBlockDataSection.hh"
#include "KinokoIndexedDataSection.hh"
#include "KinokoTaggedDataSection.hh"
#include "KinokoNestedDataSection.hh"


class TKinokoDataAnalyzer {
  public:
    TKinokoDataAnalyzer(void);
    virtual ~TKinokoDataAnalyzer();
    virtual void Destroy(void) {}
    virtual bool IsSharable(void);
    virtual void ReadDataSource(TKinokoDataSource* DataSource) throw(TKinokoException);
    virtual int ProcessDataPacket(void* DataPacket, TKinokoDataSource* DataSource = 0, TKinokoDataSection* DataSection = 0) throw(TKinokoException);
    virtual int ProcessTrailerPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
    virtual void Reset(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    virtual int ProcessIndexedData(void* DataPacket, TKinokoIndexedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessTaggedData(void* DataPacket, TKinokoTaggedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessBlockData(void* DataPacket, TKinokoBlockDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessNestedData(void* DataPacket, TKinokoNestedDataSection* DataSection) throw(TKinokoException);
  private: 
    TKinokoDataSource* _DataSource;
};


class TKinokoDataAnalyzerList: public TKinokoDataAnalyzer {
  public:
    TKinokoDataAnalyzerList(void);
    virtual ~TKinokoDataAnalyzerList();
    virtual void Destroy(void);
    virtual void ReadDataSource(TKinokoDataSource* DataSource) throw(TKinokoException);
    virtual int ProcessDataPacket(void* DataPacket, TKinokoDataSource* DataSource = 0, TKinokoDataSection* DataSection = 0) throw(TKinokoException);
    virtual int ProcessTrailerPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
    virtual void Reset(void) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  public:
    virtual void AddAnalyzer(TKinokoDataAnalyzer* Analyzer);
    virtual void DestroyAnalyzer(void);
  protected:
    TKinokoDataAnalyzer** _AnalyzerList;
    int _NumberOfAnalyzers;
    int _AnalyzerListCapacity;
};


#endif
