/* KinokoDataDistributor.hh */
/* Created by Enomoto Sanshiro on 23 October 1999. */
/* Last updated by Enomoto Sanshiro on 1 September 2001. */


#ifndef __KinokoDataDistributor_hh__
#define __KinokoDataDistributor_hh__


#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "KinokoDataDescriptor.hh"
#include "KinokoDataAnalyzer.hh"


class TKinokoDataDistributor {
  public:
    TKinokoDataDistributor(void);
    virtual ~TKinokoDataDistributor();
    virtual void RegisterAnalyzer(const std::string& DataSourceName, TKinokoDataAnalyzer* Analyzer);
    virtual void RegisterCommonAnalyzer(TKinokoDataAnalyzer* Analyzer);
    virtual void DestroyAnalyzer(void);
    virtual void ProcessDataDescriptor(TKinokoDataDescriptor* DataDescriptor) throw(TKinokoException);
    virtual int ProcessDataPacket(void* DataPacket) throw(TKinokoException);
    virtual int ProcessTrailerPacket(void* DataPacket) throw(TKinokoException);
    virtual TKinokoDataDescriptor* DataDescriptor(void);
    virtual void Dump(std::ostream& os);
  protected:
    TKinokoDataDescriptor* _DataDescriptor;
    std::vector<std::pair<std::string, TKinokoDataAnalyzer*> > _AnalyzerNameList;
    TKinokoDataAnalyzer** _AnalyzerList;
    std::map<long, TKinokoDataAnalyzer*> _OtherAnalyzerTable;
    bool _IsAnonymousAnalyzerAvailable;
    int _AnalyzerListSize;
};


#endif
