/* KinokoDataDumper.hh */
/* Created by Enomoto Sanshiro on 6 May 2001. */
/* Last updated by Enomoto Sanshiro on 6 May 2001. */


#ifndef __KinokoDataDumper_hh__
#define __KinokoDataDumper_hh__


#include <iostream>
#include <vector>
#include "KinokoDataSource.hh"
#include "KinokoDataSection.hh"
#include "KinokoDataAnalyzer.hh"
#include "KinokoIndexedDataSection.hh"
#include "KinokoBlockDataSection.hh"
#include "KinokoTaggedDataSection.hh"
#include "KinokoNestedDataSection.hh"


class TKinokoDataDumper: public TKinokoDataAnalyzer {
  public:
    TKinokoDataDumper(std::ostream& OutputStream);
    virtual ~TKinokoDataDumper();
    virtual bool IsSharable(void);
    virtual int ProcessDataPacket(void* DataPacket, TKinokoDataSource* DataSource = 0, TKinokoDataSection* DataSection = 0) throw(TKinokoException);
    virtual int ProcessTrailerPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
  protected:
    virtual int ProcessIndexedData(void* DataPacket, TKinokoIndexedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessTaggedData(void* DataPacket, TKinokoTaggedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessBlockData(void* DataPacket, TKinokoBlockDataSection* DataSectrion) throw(TKinokoException);
  protected:
    std::ostream& _OutputStream;
    int _NestCount;
};


class TKinokoDataTabler: public TKinokoDataAnalyzer {
  public:
    TKinokoDataTabler(std::ostream& OutputStream);
    virtual ~TKinokoDataTabler();
    virtual int ProcessTrailerPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
  protected:
    virtual int ProcessIndexedData(void* DataPacket, TKinokoIndexedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessTaggedData(void* DataPacket, TKinokoTaggedDataSection* DataSection) throw(TKinokoException);
  protected:
    std::ostream& _OutputStream;
    int _EventCount;
    std::vector<int> _DataList;
    bool _IsVeryFirst, _IsValidRecord;
};


#endif
