/* KinokoDataProcessor.hh */
/* Created by Enomoto Sanshiro on 20 April 2001. */
/* Last updated by Enomoto Sanshiro on 23 April 2001. */


#ifndef __KinokoDataProcessor_hh__
#define __KinokoDataProcessor_hh__


#include <iostream>
#include <string>
#include "KinokoLogger.hh"
#include "KinokoStream.hh"
#include "KinokoDataStreamFormatter.hh"
#include "KinokoDataDescriptor.hh"
#include "KinokoDataSource.hh"
#include "KinokoDataStreamMonitor.hh"


class TKinokoDataSender {
  public:
    TKinokoDataSender(void);
    virtual ~TKinokoDataSender();
    virtual void ConstructOutlet(TKinokoOutputStream* OutputStream, TKinokoDataSource* DataSource);
  public:
    virtual void SendDataDescriptorPacket(void) throw(TKinokoException);
    virtual void SendRunBeginPacket(void) throw(TKinokoException);
    virtual void SendRunEndPacket(void) throw(TKinokoException);
    virtual void SendEventTrailerPacket(void) throw(TKinokoException);
    virtual void SendPacket(void* Packet, long PacketSize) throw(TKinokoException);
  protected:
    TKinokoOutputStream* _OutputStream;
    TKinokoDataStreamFormatter* _OutputStreamFormatter;
    TKinokoDataDescriptor* _OutputDataDescriptor;
    TKinokoDataSource* _OutputDataSource;
};


class TKinokoDataReceiver {
  public:
    TKinokoDataReceiver(void);
    virtual ~TKinokoDataReceiver();
    virtual void ConstructInlet(TKinokoInputStream* InputStream);
    virtual void SetStreamCommandProcessor(TKinokoStreamCommandProcessor* Processor);
    virtual TKinokoDataDescriptor* InputDataDescriptor(void);
    virtual TKinokoDataStreamMonitor* DataStreamMonitor(void);
    virtual void SetChainedOutput(TKinokoOutputStream* OutputStream);
  public:
    virtual int ProcessInputStream(void) throw(TKinokoException);
    virtual void ProcessPacket(void* DataPacket, long PacketSize) throw(TKinokoException);
    virtual bool ProcessDataDescriptorPacket(void* DataPacket, long PacketSize) throw(TKinokoException);
    virtual bool ProcessCommandPacket(void* DataPacket, long PacketSize);
    virtual bool ProcessDataPacket(void* DataPacket, long PacketSize);
    virtual bool ProcessTrailerPacket(void* DataPacket, long PacketSize);
  protected:
    virtual void OnRunBegin(void) throw(TKinokoException) {}
    virtual void OnRunEnd(void) throw(TKinokoException) {}
    virtual void OnReceivePacket(void* DataPacket, long PacketSize) throw(TKinokoException) {}
    virtual void OnReceiveDataDescriptorPacket(void* DataPacket, long PacketSize) throw(TKinokoException) {}
    virtual void OnReceiveCommandPacket(void* DataPacket, long PacketSize) throw(TKinokoException) {}
    virtual void OnReceiveDataPacket(void* DataPacket, long PacketSize) throw(TKinokoException) {}
    virtual void OnReceiveTrailerPacket(void* DataPacket, long PacketSize) throw(TKinokoException) {}
    virtual void OnReceiveEventTrailerPacket(void* DataPacket, long PacketSize) throw(TKinokoException) {}
  protected:
    TKinokoInputStream* _InputStream;
    TKinokoDataStreamScanner* _InputStreamScanner;
    TKinokoDataDescriptor* _InputDataDescriptor;
    TKinokoOutputStream* _ChainedOutputStream;
    TKinokoDataStreamMonitor* _DataStreamMonitor;
  private:
    TKinokoStreamCommandProcessor* _StreamCommandProcessor;
    TKinokoStreamCommandProcessor* _DefaultStreamCommandProcessor;
};


class TKinokoDataProducer: public TKinokoDataSender {
  public:
    TKinokoDataProducer(void);
    virtual ~TKinokoDataProducer();
    virtual void AttachIO(std::istream& InputIoStream, std::ostream& OutputIoStream, TKinokoLogger* Logger);
    virtual void Construct(const std::string& Name, TKinokoOutputStream* OutputStream, int DataSourceId) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void) throw(TKinokoException);
  protected:
    virtual void BuildDataSource(TKinokoDataSource* DataSource) = 0;
    virtual void OnConstruct(void) throw(TKinokoException) {}
    virtual void OnDestruct(void) throw(TKinokoException) {}
  protected:
    std::istream* _InputIoStream;
    std::ostream* _OutputIoStream;
    TKinokoLogger* _Logger;
};


class TKinokoDataProcessor: public TKinokoDataReceiver, public TKinokoDataSender {
  public:
    TKinokoDataProcessor(void);
    virtual ~TKinokoDataProcessor();
    virtual void AttachIO(std::istream& InputIoStream, std::ostream& OutputIoStream, TKinokoLogger* Logger);
    virtual void Construct(const std::string& Name, TKinokoInputStream* InputStream, TKinokoOutputStream* OutputStream, int DataSourceId) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void) throw(TKinokoException);
  protected:
    virtual void BuildDataSource(TKinokoDataSource* DataSource) = 0;
    virtual void OnConstruct(void) throw(TKinokoException) {}
    virtual void OnDestruct(void) throw(TKinokoException) {}
  protected:
    std::istream* _InputIoStream;
    std::ostream* _OutputIoStream;
    TKinokoLogger* _Logger;
};


class TKinokoDataConsumer: public TKinokoDataReceiver {
  public:
    TKinokoDataConsumer(void);
    virtual ~TKinokoDataConsumer();
    virtual void AttachIO(std::istream& InputIoStream, std::ostream& OutputIoStream, TKinokoLogger* Logger);
    virtual void Construct(const std::string& Name, TKinokoInputStream* InputStream) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void) throw(TKinokoException);
  protected:
    virtual void OnConstruct(void) throw(TKinokoException) {}
    virtual void OnDestruct(void) throw(TKinokoException) {}
  protected:
    std::istream* _InputIoStream;
    std::ostream* _OutputIoStream;
    TKinokoLogger* _Logger;
};


#endif
