/* KinokoDataProfiler.hh */
/* Created by Enomoto Sanshiro on 23 October 1999. */
/* Last updated by Enomoto Sanshiro on 3 December 2000. */


#ifndef __KinokoDataProfiler_hh__
#define __KinokoDataProfiler_hh__


#include <iostream>
#include <string>
#include <map>
#include "KinokoDataAnalyzer.hh"


class TKinokoSectionDataSummary;
class TKinokoElementDataSummary;


class TKinokoDataProfiler: public TKinokoDataAnalyzer {
  public:
    TKinokoDataProfiler(void);
    virtual ~TKinokoDataProfiler();
    virtual int NumberOfSections(void) const;
    virtual TKinokoSectionDataSummary* SectionDataSummary(int SectionIndex);
    virtual void WriteSummaryTo(std::ostream& os);
  protected:
    virtual int ProcessIndexedData(void* DataPacket, TKinokoIndexedDataSection* DataSection) throw(TKinokoException);
    virtual int ProcessTaggedData(void* DataPacket, TKinokoTaggedDataSection* DataSection) throw(TKinokoException);
  protected:
    int _NumberOfSections;
    std::map<int, TKinokoSectionDataSummary*> _SectionSummaryTable;
};


class TKinokoSectionDataSummary {
  public:
    TKinokoSectionDataSummary(const std::string& SectionName);
    virtual ~TKinokoSectionDataSummary();
    virtual int ProcessElementData(int Address, int Data, const std::string& FieldName = "");
    virtual std::string SectionName(void) const;
    virtual int NumberOfChannels(void) const;
    virtual TKinokoElementDataSummary* ElementDataSummary(int Channel);
  protected:
    std::string _SectionName;
    int _NumberOfChannels;
    std::map<int, TKinokoElementDataSummary*> _ElementSummaryTable;
};


class TKinokoElementDataSummary {
  public:
    TKinokoElementDataSummary(const std::string& ElementName);
    virtual ~TKinokoElementDataSummary();
    virtual int ProcessElementData(int Data);
    virtual const std::string& ElementName(void) const;
    virtual int NumberOfEntries(void) const;
    virtual int MinimumValue(void) const;
    virtual int MaximumValue(void) const;
    virtual long Total(void) const;
    virtual double Mean(void) const;
    virtual double Deviation(void) const;
  protected:
    std::string _ElementName;
    int _NumberOfEntries;
    int _MinimumValue;
    int _MaximumValue;
    long _TotalValue;
    double _TotalSquaredValue;
};


#endif
