/* KinokoHistogramWriter.cc */
/* Created by Enomoto Sanshiro on 29 October 1999. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#include <string>
#include <cmath>
#include "KaspHistogram.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoHistogramWriter.hh"

using namespace std;


TKinokoHistogramWriter::TKinokoHistogramWriter(TKaspHistogram* Histogram, const string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier)
{
    _Histogram = Histogram;
    _SectionPath = SectionPath;
    _ElementSpecifier = ElementSpecifier;

    AddSection(SectionPath);

    _TargetName = "untitled";
}

TKinokoHistogramWriter::~TKinokoHistogramWriter()
{
}

void TKinokoHistogramWriter::Destroy(void)
{
    delete _Histogram;
}

void TKinokoHistogramWriter::Reset(void) throw(TKinokoException)
{
    _Histogram->Clear();
}

int TKinokoHistogramWriter::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    int Address, Data;
    while (SectionData->GetNextOf(_ElementSpecifier, Address, Data)) {
	_Histogram->Fill(_ElementSpecifier.ConvertData(Data));
    }

    return 1;
}

void TKinokoHistogramWriter::SetTargetName(const std::string& Name)
{
    _TargetName = Name;
}

void TKinokoHistogramWriter::Dump(ostream& os, const string& Indent)
{
    os << Indent << "FillHistogram" << "\t" << _TargetName;
    os << ", \"" << _SectionPath << "\", " << _ElementSpecifier.AsString();
    os << endl;
}
