/* KinokoHistogramWriter.hh */
/* Created by Enomoto Sanshiro on 29 October 1999. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#ifndef __KinokoHistogramWriter_hh__
#define __KinokoHistogramWriter_hh__


#include <string>
#include "KaspHistogram.hh"
#include "KinokoSectionDataAnalyzer.hh"


class TKinokoHistogramWriter: public TKinokoSectionDataAnalyzer {
  public:
    TKinokoHistogramWriter(TKaspHistogram* Histogram, const std::string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier);
    virtual ~TKinokoHistogramWriter();
    virtual void Destroy(void);
    virtual void Reset(void) throw(TKinokoException);
    virtual void SetTargetName(const std::string& Name);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
  protected:
    TKaspHistogram* _Histogram;
    std::string _SectionPath;
    TKinokoDataElementSpecifier _ElementSpecifier;
    std::string _TargetName;
};


#endif
