/* KinokoMapWriter.cc */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#include <string>
#include "KaspMap.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoMapWriter.hh"

using namespace std;


TKinokoMapWriter::TKinokoMapWriter(TKaspMap* Map, const string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier)
{
    _Map = Map;
    _SectionPath = SectionPath;
    _ElementSpecifier = ElementSpecifier;

    AddSection(SectionPath);

    _TargetName = "untitled";
}

TKinokoMapWriter::~TKinokoMapWriter()
{
}

void TKinokoMapWriter::Destroy(void)
{
    delete _Map;
    TKinokoSectionDataAnalyzer::Destroy();
}

void TKinokoMapWriter::Reset(void) throw(TKinokoException)
{
    _Map->Clear();
}

int TKinokoMapWriter::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{

    int Address, Data;
    while (SectionData->GetNextOf(_ElementSpecifier, Address, Data)) {
	_Map->Fill(Address, _ElementSpecifier.ConvertData(Data));
    }

    return 1;
}

void TKinokoMapWriter::SetTargetName(const std::string& Name)
{
    _TargetName = Name;
}

void TKinokoMapWriter::Dump(ostream& os, const string& Indent)
{
    os << Indent << "FillMap" << "\t" << _TargetName;
    os << ", \"" << _SectionPath << "\"";
    os << endl;
}
