/* KinokoMapWriter.hh */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#ifndef __KinokoMapWriter_hh__
#define __KinokoMapWriter_hh__


#include <string>
#include <vector>
#include "KaspMap.hh"
#include "KinokoSectionDataAnalyzer.hh"


class TKinokoMapWriter: public TKinokoSectionDataAnalyzer {
  public:
    TKinokoMapWriter(TKaspMap* Map, const std::string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier);
    virtual ~TKinokoMapWriter();
    virtual void Destroy(void);
    virtual void Reset(void) throw(TKinokoException);
    virtual void SetTargetName(const std::string& Name);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
  protected:
    TKaspMap* _Map;
    std::string _SectionPath;
    TKinokoDataElementSpecifier _ElementSpecifier;
    std::string _TargetName;
};


#endif
