/* KinokoTabularWriter.cc */
/* Created by Enomoto Sanshiro on 25 January 2001. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#include <strstream>
#include <string>
#include "KaspTabular.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoTabularWriter.hh"

using namespace std;


TKinokoTabularWriter::TKinokoTabularWriter(TKaspTabular* Tabular, const string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier)
{
    _Tabular = Tabular;
    _SectionPath = SectionPath;
    _ElementSpecifier = ElementSpecifier;

    AddSection(SectionPath);

    _TargetName = "untitled";
}

TKinokoTabularWriter::~TKinokoTabularWriter()
{
}

void TKinokoTabularWriter::Destroy(void)
{
    delete _Tabular;
    TKinokoSectionDataAnalyzer::Destroy();
}

void TKinokoTabularWriter::Reset(void) throw(TKinokoException)
{
    _Tabular->Clear();
}

int TKinokoTabularWriter::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    char Value[32];
    string FieldName;
    int Data;
    while (SectionData->GetNextOf(_ElementSpecifier, FieldName, Data)) {
	ostrstream ValueStream(Value, sizeof(Value));
	ValueStream << _ElementSpecifier.ConvertData(Data) << ends;
	_Tabular->Fill(FieldName, Value);
    }

    return 1;
}

void TKinokoTabularWriter::SetTargetName(const std::string& Name)
{
    _TargetName = Name;
}

void TKinokoTabularWriter::Dump(ostream& os, const string& Indent)
{
    os << Indent << "FillTabular" << "\t" << _TargetName;
    os << ", \"" << _SectionPath << "\", " << _ElementSpecifier.AsString();
    os << endl;
}
