/* KinokoTabularWriter.hh */
/* Created by Enomoto Sanshiro on 25 January 2001. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#ifndef __KinokoTabularWriter_hh__
#define __KinokoTabularWriter_hh__


#include <string>
#include "KaspTabular.hh"
#include "KinokoSectionDataAnalyzer.hh"


class TKinokoTabularWriter: public TKinokoSectionDataAnalyzer {
  public:
    TKinokoTabularWriter(TKaspTabular* Tabular, const std::string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier);
    virtual ~TKinokoTabularWriter();
    virtual void Destroy(void);
    virtual void Reset(void) throw(TKinokoException);
    virtual void SetTargetName(const std::string& Name);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
  protected:
    TKaspTabular* _Tabular;
    std::string _SectionPath;
    TKinokoDataElementSpecifier _ElementSpecifier;
    std::string _TargetName;
};


#endif
