/* KinokoWaveWriter.cc */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#include <string>
#include <algorithm>
#include "KaspWave.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoWaveWriter.hh"

using namespace std;


TKinokoWaveWriter::TKinokoWaveWriter(TKaspWave* Wave, const string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier)
{
    _Wave = Wave;
    _SectionPath = SectionPath;
    _ElementSpecifier = ElementSpecifier;

    AddSection(SectionPath);

    _TargetName = "untitled";
}

TKinokoWaveWriter::~TKinokoWaveWriter()
{
}

void TKinokoWaveWriter::Destroy(void)
{
    delete _Wave;
}

void TKinokoWaveWriter::Reset(void) throw(TKinokoException)
{
    _Wave->Clear();
}

int TKinokoWaveWriter::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    int DataIndex = 0;
    int Address, Data;
    while (SectionData->GetNextOf(_ElementSpecifier, Address, Data)) {
	_Wave->Fill(DataIndex, _ElementSpecifier.ConvertData(Data));
	DataIndex++;
    }

    return 1;
}

void TKinokoWaveWriter::SetTargetName(const std::string& Name)
{
    _TargetName = Name;
}

void TKinokoWaveWriter::Dump(ostream& os, const string& Indent)
{
    os << Indent << "FillWave" << "\t" << _TargetName;
    os << ", \"" << _SectionPath << "\", " << _ElementSpecifier.AsString();
    os << endl;
}
