/* KinokoArena.hh */
/* Created by Enomoto Sanshiro on 19 April 1998. */
/* Last updated by Enomoto Sanshiro on 15 January 2002. */


#define INLINE_KINOKO_ARENA 1


#ifndef __KinokoArena_hh__
#define __KinokoArena_hh__


#include <sys/types.h>


#if INLINE_KINOKO_ARENA
#define INLINE inline
#else
#define INLINE 
#endif


class TKinokoArenaEntry {
  public:
    INLINE TKinokoArenaEntry(int EntryIndex);
    INLINE ~TKinokoArenaEntry();
    INLINE void Attach(void* Address, size_t Capacity, int NumberOfAttached);
    INLINE void Detach(void);
    INLINE void AddNext(TKinokoArenaEntry* Entry);
    INLINE int EntryIndex(void) const;
    INLINE void* Address(void) const;
    INLINE size_t Capacity(void) const;
    INLINE int ReferenceCount(void) const;
    INLINE TKinokoArenaEntry* Prev(void) const;
    INLINE TKinokoArenaEntry* Next(void) const;
  private:
    int _EntryIndex;
    void* _Address;
    size_t _Capacity;
    int _ReferenceCount;
    TKinokoArenaEntry* _PrevEntry;
    TKinokoArenaEntry* _NextEntry;
};


class TKinokoArenaEntryPool {
  public:
    INLINE TKinokoArenaEntryPool(int MaxNumberOfEntries);
    INLINE ~TKinokoArenaEntryPool();
    INLINE TKinokoArenaEntry* AllocateEntry(void);
    INLINE void ReleaseEntry(TKinokoArenaEntry* Entry);
  private:
    int _EntryTableSize;
    TKinokoArenaEntry** _EntryTable;
    bool* _OccupancyTable;
    int _LastEntryIndex;
};


class TKinokoArena {
  public:
    INLINE TKinokoArena(void* BaseAddress, size_t ArenaSize, int MaxNumberOfEntries);
    INLINE ~TKinokoArena();
    INLINE bool CreateEntry(size_t Capacity, void*& Address, int NumberOfAttached);
    INLINE bool DetachEntry(void* Address);
    INLINE size_t AvailableSize(void) const;
    INLINE size_t AvailableSize(const void* EntryAddress) const;
    INLINE int NumberOfAvailableEntries(void) const;
    INLINE int IsAllocatable(size_t Size) const;
    INLINE int NumberOfEntries(void) const;
    INLINE size_t UsedSize(void) const;
    INLINE long DataHeadOffset(void) const;
    INLINE long NextStartOffset(void) const;
  private:
    typedef char unit;
    void* _BaseAddress;
    size_t _ArenaSize;
    TKinokoArenaEntry* _HeadEntry;
    TKinokoArenaEntry* _TailEntry;
    TKinokoArenaEntryPool* _EntryPool;
    int _MaxNumberOfEntries;
    int _NumberOfEntries;
    size_t _UsedSize;
};


#if INLINE_KINOKO_ARENA
#include "KinokoArena.cc"
#endif

#undef INLINE


#endif
