/* KinokoBufferClient.hh */
/* Created by Enomoto Sanshiro on 19 April 1998. */
/* Last updated by Enomoto Sanshiro on 21 August 2002. */


#ifndef __KinokoBufferClient_hh__
#define __KinokoBufferClient_hh__


#include "MushDefs.hh"
#include "MushTimer.hh"
#include "MushIpc.hh"
#include "KinokoDefs.hh"
#include "KinokoBufferServer.hh"



class TKinokoBufferClient {
  public:
    TKinokoBufferClient(int SharedMemoryProjectId, int MessageQueueProjectId, TMushIntervalTimer* TimeKeeper, TKinokoBufferLogger* Logger) throw(TKinokoException);
    virtual ~TKinokoBufferClient();
    long MessageQueueAddress(void);
  protected:
    TMushClientSharedMemory* _SharedMemory;
    TMushClientMessageQueue* _MessageQueue;
    TMushIntervalTimer* _TimeKeeper;
    TKinokoBufferLogger* _Logger;
    unsigned long _BaseAddress;
};


class TKinokoBufferWriter: public TKinokoBufferClient {
  public:
    TKinokoBufferWriter(int SharedMemoryProjectId, int MessageQueueProjectId, TMushIntervalTimer* TimeKeeper, TKinokoBufferLogger* Logger) throw(TKinokoException);
    virtual ~TKinokoBufferWriter();
    int ReserveWriteEntry(size_t Capacity);
    bool GetWriteEntry(void*& Address, size_t Capacity);
    bool SendStrobe(const void* Address, size_t Size);
  protected:
    int _NumberOfReserved;
    TKinokoBufferPacket _Packet;
};


class TKinokoBufferReader: public TKinokoBufferClient {
  public:
    TKinokoBufferReader(int SharedMemoryProjectId, int MessageQueueProjectId, TMushIntervalTimer* TimeKeeper, TKinokoBufferLogger* Logger) throw(TKinokoException);
    virtual ~TKinokoBufferReader();
    bool HasData(void);
    int NextDataSize(void);
    bool GetReadEntry(void*& Address, size_t& Size);
    bool SendAcknowledge(const void* Address);
  protected:
    void Attach(void);
    void Detach(void);
  protected:
    bool _IsAttached;
    TKinokoBufferPacket _IncomingPacket, _OutgoingPacket;
    bool _IsPacketDataAvailable;
};


#endif
