/* KinokoBufferLogger.hh */
/* Created by Enomoto Sanshiro on 8 January 2000. */
/* Last updated by Enomoto Sanshiro on 8 January 2000. */

#ifndef __KinokoBufferLogger_hh__
#define __KinokoBufferLogger_hh__

#include <iostream>
#include <string>
#include "KinokoDefs.hh"


class TKinokoBufferLogger {
  public:
    enum TMessageLevel {
	mlInformation,   // no need to record
	mlLog,           // will be recorded
	mlWarning,       // may induce trouble
	mlError,         // need to be fixed, but run will go on
	mlPanic          // critical, run will be stopped immediately
    };
  public:
    TKinokoBufferLogger(void);
    virtual ~TKinokoBufferLogger();
    virtual int Write(const std::string& Message, int MessageLevel) throw(TKinokoException) = 0;
};


class TKinokoBufferStreamLogger: public TKinokoBufferLogger {
  public:
    TKinokoBufferStreamLogger(std::ostream& os);
    virtual ~TKinokoBufferStreamLogger();
    virtual int Write(const std::string& Message, int MessageLevel) throw(TKinokoException);
  protected:
    std::ostream& _os;
};


class TKinokoPrescaledBufferLogger: public TKinokoBufferLogger {
  public:
    TKinokoPrescaledBufferLogger(TKinokoBufferLogger* Logger, int Interval_sec = 1);
    virtual ~TKinokoPrescaledBufferLogger();
    virtual int Write(const std::string& Message, int MessageLevel) throw(TKinokoException);
  protected:    
    TKinokoBufferLogger* _Logger;
    int _Interval_sec;
    int _LastLogTime;
};


#endif
