/* KinokoBufferServer.hh */
/* Created by Enomoto Sanshiro on 19 April 1998. */
/* Last updated by Enomoto Sanshiro on 21 August 2002. */


#ifndef __KinokoBufferServer_hh__
#define __KinokoBufferServer_hh__


#include <vector>
#include <deque>
#include "MushDefs.hh"
#include "MushTimer.hh"
#include "MushIpc.hh"
#include "KinokoDefs.hh"
#include "KinokoArena.hh"
#include "KinokoBufferLogger.hh"



struct TKinokoBufferPacket {
  public:
    enum TKinokoBufferPacketType {
	ptWriteRequest,
	ptEntryReady,
	ptDataStrobe,
	ptReadRequest,
	ptDataAcknowledge,
	ptReaderAttachRequest,
	ptReaderDetachRequest,
	ptDetachAcknowledge
    };
  public:
    long ReceiverAddress;
    long SenderAddress;
    unsigned long OffsetAddress;
    unsigned long Size;
    int PacketType;
};


class TKinokoBufferRequest {
  public:
    TKinokoBufferRequest(const TKinokoBufferPacket &KinokoBufferPacket) {
	WriterMessageAddress = KinokoBufferPacket.SenderAddress;
	OffsetAddress = KinokoBufferPacket.OffsetAddress;
	Size = KinokoBufferPacket.Size;
    }
  public:
    long WriterMessageAddress;
    unsigned long OffsetAddress;
    unsigned long Size;
};


class TKinokoBufferServer {
  public:
    TKinokoBufferServer(int SharedMemoryProjectId, int MessageQueueProjectId, unsigned long BufferSize, int BufferEntryTableSize, TKinokoBufferLogger* Logger) throw(TKinokoException);
    ~TKinokoBufferServer();
    int DoTransaction(TMushIntervalTimer *TimeKeeper);
    static const char* IpcProjectPath(void);
    static long MessageQueueAddress(void);
    void ReportStatus(void);
  private:
    void DispatchMessage(const TKinokoBufferPacket& Packet);
    void ProcessPendingRequests(void);
    bool ProcessWriteRequest(const TKinokoBufferRequest& WriteRequest);
    bool ProcessReadRequest(const TKinokoBufferRequest& ReadRequest);
    void SendEntryReady(const TKinokoBufferRequest& WriteRequest, unsigned long OffsetAddress);
    void SendReadRequest(const TKinokoBufferRequest& ReadRequest);
    void DetachEntry(unsigned long OffsetAddress);
    void AttachReader(long ReaderAddress);
    void DetachReader(long ReaderAddress);
  private:
    unsigned long _BaseAddress;
    unsigned long _BufferSize;
    int _BufferEntryTableSize;
    TMushServerSharedMemory* _SharedMemory;
    TMushServerMessageQueue* _MessageQueue;
    TKinokoArena* _Arena;
    TKinokoBufferLogger* _Logger;
    TKinokoBufferLogger* _PrescaledLogger;
    int _NumberOfReaders;
    std::vector<long> _ReaderAddressList;
  private:
    std::deque<TKinokoBufferRequest> _WriteRequestQueue;
    std::deque<TKinokoBufferRequest> _ReadRequestQueue;
    int _NumberOfUnreadPackets, _MaxNumberOfUnreadPackets;
    unsigned long _WrittenDataSize, _NumberOfWrittenPackets;
    long _LastReportTime;
  private:
    TKinokoBufferPacket _Packet;
};


#endif
