/* KinokoActiveStreamComponent.hh */
/* Created by Enomoto Sanshiro on 9 October 2000. */
/* Last updated by Enomoto Sanshiro on 18 February 2002. */


#ifndef __KinokoActiveStreamComponent_hh__
#define __KinokoActiveStreamComponent_hh__


#include <string>
#include "MushNetworkSocket.hh"
#include "MushDecoratedSocket.hh"
#include "KinokoStream.hh"
#include "KinokoFileStream.hh"
#include "KinokoSocketStream.hh"
#include "KinokoBufferStream.hh"
#include "KinokoDataStreamFormatter.hh"
#include "KinokoStreamComponent.hh"


class TKinokoActiveStreamComponent: public TKinokoStreamComponent {
  public:
    TKinokoActiveStreamComponent(const std::string& TypeName);
    virtual ~TKinokoActiveStreamComponent();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual int DoTransaction(void) throw(TKcomException);
    virtual void StartDataProcessing(void) throw(TKinokoException);
    virtual void StopDataProcessing(void) throw(TKinokoException);
  private:
    virtual int ProcessSetSourceEvent(TKcomEvent& Event);
    virtual int ProcessSetSinkEvent(TKcomEvent& Event);
    virtual int ProcessSetSourceSinkEvent(TKcomEvent& Event);
    virtual int ProcessConnectEvent(TKcomEvent& Event);
    virtual int ProcessConstructEvent(TKcomEvent& Event);
    virtual int ProcessHaltEvent(TKcomEvent& Event);
    virtual int ProcessDestructEvent(TKcomEvent& Event);
    virtual int ProcessDisconnectEvent(TKcomEvent& Event);
    virtual int ProcessQuitEvent(TKcomEvent& Event);
    virtual void SetSource(const std::string& SourceComponentName);
    virtual void SetSink(const std::string& SinkComponentName);
    virtual void Connect(void) throw(TKinokoException);
    virtual void Disconnect(void) throw(TKinokoException);
    virtual void ConnectSource(void) throw(TKinokoException);
    virtual void ConnectSink(void) throw(TKinokoException);
  protected:
    virtual void SetProperties(void) throw(TKinokoException) = 0;
    virtual void Construct(void) throw(TKinokoException) = 0;
    virtual void Destruct(void) throw(TKinokoException) = 0;
    virtual int ProcessData(void) throw(TKinokoException) = 0;
    virtual int ProcessDataIfAvailable(void) throw(TKinokoException);
    virtual void OnStart(void) throw(TKinokoException) {}
    virtual void OnStop(void) throw(TKinokoException) {}
    virtual int GetDataSourceId(void);
    virtual int GetPortNumber(void);
  protected:
    enum TPropertyId {
	PropertyId_PortNumber = TKinokoStreamComponent::_NumberOfProperties,
	_NumberOfProperties
    };
    enum TEventId {
	EventId_SetSink = TKinokoStreamComponent::_NumberOfEvents,
	EventId_SetSource,
	EventId_SetSourceSink,
	EventId_Connect,
	EventId_Construct,
	EventId_Halt,
	EventId_Destruct,
	EventId_Disconnect,
	EventId_Quit,
	_NumberOfEvents
    };
  protected:
    TKinokoInputStream* _InputDataStream;
    TKinokoOutputStream* _OutputDataStream;
    TKinokoStreamCommandProcessor* _StreamCommandProcessor;
    bool _IsInputStreamUsed;
    bool _IsOutputStreamUsed;
  private:
    TStreamType _SourceStreamType;
    std::string _SourceHostName;
    std::string _SourceComponentName;
    TMushFramedSocket* _InputSocket;
    long _InputSharedMemoryId, _InputMessageQueueId;
    TKinokoBufferReader* _BufferReader;
  private:
    TStreamType _SinkStreamType;
    std::string _SinkHostName;
    std::string _SinkComponentName;
    TMushFramedSocket* _OutputSocket;
    long _OutputSharedMemoryId, _OutputMessageQueueId;
    TKinokoBufferWriter* _BufferWriter;
  private:
    int _PortNumberBase;
    int _DataSourceIdBase;
    TKinokoBufferLogger* _BufferLogger;
};


#endif
