/* KinokoBufferCom.hh */
/* Created by Enomoto Sanshiro on 20 October 2000. */
/* Last updated by Enomoto Sanshiro on 9 October 2000. */


#ifndef __KinokoBufferCom_hh__
#define __KinokoBufferCom_hh__


#include "MushMisc.hh"
#include "KinokoBufferServer.hh"
#include "KinokoStreamComponent.hh"


class TKinokoBufferCom: public TKinokoStreamComponent {
  public:
    TKinokoBufferCom(void);
    virtual ~TKinokoBufferCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int DoTransaction(void) throw(TKcomException);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  protected:
    virtual int ProcessSetBufferSizeEvent(TKcomEvent& Event);
    virtual int ProcessSetReportIntervalEvent(TKcomEvent& Event);
    virtual int ProcessStartEvent(TKcomEvent& Event);
    virtual int ProcessQuitEvent(TKcomEvent& Event);
    virtual void SetProperties(void) throw(TKinokoException);
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void)throw(TKinokoException);
  protected:
    enum TPropertyId {
	PropertyId_SharedMemoryId = TKinokoStreamComponent::_NumberOfProperties,
	PropertyId_MessageQueueId,
	_NumberOfProperties
    };
    enum TEventId {
	EventId_SetBufferSize = TKinokoStreamComponent::_NumberOfEvents,
	EventId_SetReportInterval,
	EventId_Start,
	EventId_Quit,
	_NumberOfEvents
    };
  protected:
    int _SharedMemoryId;
    int _MessageQueueId;
    int _BufferSize;
    int _BufferEntryTableSize;
    TKinokoBufferServer *_BufferServer;
    TKinokoBufferLogger* _BufferLogger;
    int _ReportInterval, _LastReportTime;
    int _NumberOfTransactionsSinceLastReport;
};


#endif
