/* KinokoCollectorCom.hh */
/* Created by Enomoto Sanshiro on 11 October 2000. */
/* Last updated by Enomoto Sanshiro on 18 January 2002. */


#ifndef __KinokoCollectorCom_hh__
#define __KinokoCollectorCom_hh__


#include <string>
#include <vector>
#include "KinokoDaqFrontend.hh"
#include "KinokoPlatform.hh"
#include "KinokoStreamSourceComponent.hh"


class TKinokoCollectorCom: public TKinokoStreamSourceComponent {
  public:
    TKinokoCollectorCom(void);
    virtual ~TKinokoCollectorCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual void Initialize(void) throw(TKcomException);
    virtual void Finalize(void) throw(TKcomException);
  protected:
    virtual int ProcessSetReadoutScriptEvent(TKcomEvent& Event);
    virtual int ProcessSetMaxEventCountsEvent(TKcomEvent& Event);
    virtual int ProcessSetRunLengthEvent(TKcomEvent& Event);
    virtual int ProcessExecuteCommandEvent(TKcomEvent& Event);
    virtual int ProcessDisableEvent(TKcomEvent& Event);
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void)throw(TKinokoException);
    virtual void OnStart(void) throw(TKinokoException);
    virtual void OnStop(void) throw(TKinokoException);
  protected:
    enum TEventId {
	EventId_SetReadoutScript = TKinokoStreamSourceComponent::_NumberOfEvents,
	EventId_ExecuteCommand,
	EventId_Disable,
	EventId_SetMaxEventCounts,
	EventId_SetRunLength,
	EventId_DataAcquisitionFinished,
	_NumberOfEvents
    };
  protected:
    std::string _ScriptFileName;
    std::string _DataSourceName;
    TKinokoEventEmitter* _EventEmitter;
    TKinokoRegistry* _Registry;
    TKinokoDaqFrontend* _DaqFrontend;
    bool _IsDisabled;
    bool _IsStopRequested, _IsStopped;
    unsigned long _MaxEventCounts, _EventCounts;
    long _RunLength, _StartTime;
};


#endif
