/* KinokoComponentPlatform.cc */
/* Created by Enomoto Sanshiro on 11 October 2000. */
/* Last updated by Enomoto Sanshiro on 19 May 2003. */


#include <string>
#include <vector>
#include "KinokoPlatform.hh"
#include "KinokoComponent.hh"
#include "KinokoComponentPlatform.hh"

using namespace std;


TKinokoComponentEventEmitter::TKinokoComponentEventEmitter(TKinokoComponent* Component)
{
    _Component = Component;
}

TKinokoComponentEventEmitter::~TKinokoComponentEventEmitter()
{
}

void TKinokoComponentEventEmitter::EmitEvent(const string& EventName, const vector<string>& EventArgumentList) throw(TKinokoException)
{
    _Component->EmitKcomEvent(EventName, EventArgumentList);
}

bool TKinokoComponentEventEmitter::EmitEventTo(const string& TargetName, const string& EventName, const vector<string>& EventArgumentList, string& ReturnValue) throw(TKinokoException)
{
    return _Component->EmitKcomEventTo(
	TargetName, EventName, EventArgumentList, ReturnValue
    );
}



TKinokoComponentRegistry::TKinokoComponentRegistry(TKcomRegistry* Registry)
{
    _Registry = Registry;
}

TKinokoComponentRegistry::~TKinokoComponentRegistry()
{
}

string TKinokoComponentRegistry::GetValue(const string& RegistryPath)
{
    string Value;
    _Registry->GetValue(RegistryPath, Value);

    return Value;
}

long TKinokoComponentRegistry::GetLongValue(const string& RegistryPath)
{
    long Value;
    if (! _Registry->GetLongValue(RegistryPath, Value)) {
	Value = 0;	//...
    }

    return Value;
}

void TKinokoComponentRegistry::SetValue(const string& RegistryPath, const string& Value)
{
    _Registry->SetValue(RegistryPath, Value);
}

void TKinokoComponentRegistry::SetLongValue(const string& RegistryPath, long Value)
{
    _Registry->SetLongValue(RegistryPath, Value);
}



TKinokoComponentTerminal::TKinokoComponentTerminal(TKcomTerminal* Terminal)
{
    _Terminal = Terminal;
}

TKinokoComponentTerminal::~TKinokoComponentTerminal()
{
}

int TKinokoComponentTerminal::Put(const std::string& Line) throw(TKcomException)
{
    return _Terminal->Put(Line);
}

int TKinokoComponentTerminal::Get(string& Line, char Delimiter) throw(TKcomException)
{
    return _Terminal->Get(Line, Delimiter);
}

void TKinokoComponentTerminal::SetPrompt(const string& Prompt) throw(TKcomException)
{
    _Terminal->SetPrompt(Prompt);
}
