/* KinokoDataFilterCom.hh */
/* Created by Enomoto Sanshiro on 15 January 2002. */
/* Last updated by Enomoto Sanshiro on 15 January 2002. */


#ifndef __KinokoDataFilterCom_hh__
#define __KinokoDataFilterCom_hh__


#include <string>
#include <set>
#include "KinokoStream.hh"
#include "KinokoKdfStorage.hh"
#include "KinokoDataProcessor.hh"
#include "KinokoStreamPipeComponent.hh"


class TKinokoDataFilterCom: public TKinokoStreamPipeComponent {
  public:
    TKinokoDataFilterCom(void);
    virtual ~TKinokoDataFilterCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  protected:
    virtual int ProcessAddDataSourceEvent(TKcomEvent& Event);
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void)throw(TKinokoException);
  protected:
    enum TEventId {
	EventId_AddDataSource = TKinokoStreamPipeComponent::_NumberOfEvents,
	_NumberOfEvents
    };
  protected:
    std::set<std::string> _DataSourceNameSet;
    std::set<int> _DataSourceIdSet;
    TKinokoDataReceiver* _DataReceiver;
    TKinokoDataStreamScanner* _DataStreamScanner;
};


#endif
