/* KinokoDataFlowMeter.cc */
/* Created by Enomoto Sanshiro on 22 May 2001. */
/* Last updated by Enomoto Sanshiro on 22 May 2001. */


#include "MushMisc.hh"
#include "KinokoDataProcessor.hh"
#include "KinokoTaggedDataSection.hh"
#include "KinokoDataFlowMeter.hh"

using namespace std;


TKinokoDataFlowMeter::TKinokoDataFlowMeter(void)
{
}

TKinokoDataFlowMeter::~TKinokoDataFlowMeter()
{
}

void TKinokoDataFlowMeter::BuildDataSource(TKinokoDataSource* DataSource)
{
    _DataSection = new TKinokoTaggedDataSection(DataSource, "data_flow");

    int DataWidth = 32;
    _EventRateIndex = _DataSection->AddField("event_rate", DataWidth);
    _DataFlowIndex = _DataSection->AddField("data_flow", DataWidth);

    DataSource->AddDataSection(_DataSection);
    _Formatter = _DataSection->Formatter();
}

void TKinokoDataFlowMeter::OnConstruct(void) throw(TKinokoException)
{
    _EventCount = 0;
    _DataAmount = 0;

    _LastReportTime = TMushDateTime().AsLong();
    _ReportInterval = 10;
}

void TKinokoDataFlowMeter::OnReceivePacket(void* Packet, long PacketSize) throw(TKinokoException)
{
    SendPacket(Packet, PacketSize);
}

void TKinokoDataFlowMeter::OnReceiveDataPacket(void* Packet, long PacketSize) throw(TKinokoException)
{
    _DataAmount += PacketSize;
}

void TKinokoDataFlowMeter::OnReceiveTrailerPacket(void* Packet, long PacketSize) throw(TKinokoException)
{
    _EventCount++;

    long PassedTime = TMushDateTime().AsLong() - _LastReportTime;
    if (PassedTime > _ReportInterval) {
	int EventRate = _EventCount / PassedTime;
	int DataFlow = _DataAmount / PassedTime;
	SendReportPacket(EventRate, DataFlow);

	_EventCount -= EventRate * PassedTime;
	_DataAmount -= DataFlow * PassedTime;
	_LastReportTime += PassedTime;
    }
}

void TKinokoDataFlowMeter::SendReportPacket(int EventRate, int DataFlow) throw(TKinokoException)
{
    int DataSize = _Formatter->DataSize();
    int PacketSize = _Formatter->PacketSizeFor(DataSize);

    void* Buffer;
    do {
	_OutputStream->NextEntry(Buffer, PacketSize);
    } while (Buffer == 0);

    _Formatter->WriteHeaderTo(Buffer, DataSize);
    _Formatter->WriteTo(Buffer, _EventRateIndex, EventRate);
    _Formatter->WriteTo(Buffer, _DataFlowIndex, DataFlow);

    _OutputStream->Flush(Buffer, PacketSize);

    SendEventTrailerPacket();
}
