/* KinokoEventCounterCom.hh */
/* Created by Enomoto Sanshiro on 20 May 2001. */
/* Last updated by Enomoto Sanshiro on 20 May 2001. */


#ifndef __KinokoEventCounterCom_hh__
#define __KinokoEventCounterCom_hh__


#include "KinokoDataStreamFormatter.hh"
#include "KinokoStreamSinkComponent.hh"


class TKinokoEventCounterCom: public TKinokoStreamSinkComponent {
  public:
    TKinokoEventCounterCom(void);
    virtual ~TKinokoEventCounterCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  protected:
    virtual int ProcessSetNumberOfEventsEvent(TKcomEvent& Event);
    virtual void EmitAlarmEvent(void);
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void)throw(TKinokoException);
  protected:
    enum TEventId {
	EventId_SetNumberOfEvents = TKinokoStreamSinkComponent::_NumberOfEvents,
	EventId_Alarm,
	_NumberOfEvents
    };
  protected:
    int _EventCount;
    int _MaxNumberOfEvents;
    TKinokoDataStreamScanner* _StreamScanner;
};


#endif
