/* KinokoRecorderCom.hh */
/* Created by Enomoto Sanshiro on 12 October 2000. */
/* Last updated by Enomoto Sanshiro on 27 April 2002. */


#ifndef __KinokoRecorderCom_hh__
#define __KinokoRecorderCom_hh__


#include <string>
#include <vector>
#include "MushFileSystem.hh"
#include "KinokoKdfRecorder.hh"
#include "KinokoStreamSinkComponent.hh"


class TKinokoRecorderCom: public TKinokoStreamSinkComponent {
  public:
    TKinokoRecorderCom(void);
    virtual ~TKinokoRecorderCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual void OnStop(void) throw(TKinokoException);
  protected:
    virtual int ProcessSetDataFileEvent(TKcomEvent& Event);
    virtual int ProcessMakeDirectoryEvent(TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual int ProcessIsFileReadableEvent(TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual int ProcessIsFileWritableEvent(TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual int ProcessAllowOverWriteEvent(TKcomEvent& Event);
    virtual int ProcessSetDataFileReadOnlyEvent(TKcomEvent& Event);
    virtual int ProcessEnableDataCompressionEvent(TKcomEvent& Event);
    virtual int ProcessEnableIndexEvent(TKcomEvent& Event);
    virtual int ProcessAddHeaderEntryEvent(TKcomEvent& Event);
    virtual int ProcessImportHeaderEvent(TKcomEvent& Event);
    virtual int ProcessDisableCommonHeaderEvent(TKcomEvent& Event);
    virtual int ProcessRequireDiskSpaceEvent(TKcomEvent& Event);
    virtual int ProcessSetReportIntervalEvent(TKcomEvent& Event);
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void) throw(TKinokoException);
    virtual void ReportStatistics(void) throw(TKinokoException);
  protected:
    enum TEventId {
	EventId_SetDataFile = TKinokoStreamSinkComponent::_NumberOfEvents,
	EventId_FinishRecording,
	EventId_MakeDirectory,
	EventId_IsFileReadable,
	EventId_IsFileWritable,
	EventId_AllowOverWrite,
	EventId_SetDataFileReadOnly,
	EventId_EnableDataCompression,
	EventId_EnableIndex,
	EventId_AddHeaderEntry,
	EventId_ImportHeader,
	EventId_DisableCommonHeader,
	EventId_RequireDiskSpace,
	EventId_DiskSpaceExhausted,
	EventId_SetReportInterval,
	_NumberOfEvents
    };
  protected:
    std::string _OutputFileName;
    TKinokoRecorder* _Recorder;
    int _DataFileAccessMode;
    bool _IsOverWriteAllowed;
    bool _IsDataCompressionEnabled;
    bool _IsIndexEnabled;
    bool _IsCommonHeaderDisabled;
    float _RequiredSize;
    long _RequiredBlocks;
    long _LastDiskSpaceCheckTime;
    int _ReportInterval, _LastReportTime;
    std::vector<std::pair<std::string, std::string> > _HeaderEntryList;
    std::vector<std::string> _HeaderImportingFileList;
    TKinokoDataStreamMonitor* _StreamMonitor;
    TMushFileSystem* _FileSystem;
};


#endif
