/* KinokoReproducerCom.hh */
/* Created by Enomoto Sanshiro on 24 December 2001. */
/* Last updated by Enomoto Sanshiro on 24 December 2001. */


#ifndef __KinokoReproducerCom_hh__
#define __KinokoReproducerCom_hh__


#include "KinokoStream.hh"
#include "KinokoKdfStorage.hh"
#include "KinokoDataProcessor.hh"
#include "KinokoStreamSourceComponent.hh"


class TKinokoReproducerCom: public TKinokoStreamSourceComponent {
  public:
    TKinokoReproducerCom(void);
    virtual ~TKinokoReproducerCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  protected:
    virtual int ProcessSetInputDataEvent(TKcomEvent& Event);
    virtual int ProcessSetEventIntervalEvent(TKcomEvent& Event);
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void)throw(TKinokoException);
    virtual void OnStop(void) throw(TKinokoException);
  protected:
    enum TEventId {
	EventId_SetInputData = TKinokoStreamSourceComponent::_NumberOfEvents,
	EventId_SetEventInterval,
	EventId_RunEnd,
	_NumberOfEvents
    };
  protected:
    std::string _DataFileName;
    std::string _DataSourceName;
    int _DataSourceId;
    long _IntervalSec, _IntervalUSec;
    TMushIntervalTimer* _DelayTimer;
    TKinokoKdfStorage* _Storage;
    TKinokoDataReceiver* _DataReceiver;
    TKinokoDataStreamScanner* _DataStreamScanner;
    int _NumberOfDataSources;
};


#endif
