/* KinokoStreamComponent.cc */
/* Created by Enomoto Sanshiro on 9 October 2000. */
/* Last updated by Enomoto Sanshiro on 27 May 2001. */


#include "MushTimer.hh"
#include "KcomComponent.hh"
#include "KinokoLoggerOrb.hh"
#include "KinokoBufferServer.hh"
#include "KinokoStreamComponent.hh"

using namespace std;


static const string Author = "Enomoto Sanshiro";
static const string Date = "22 January 2002";
static const int MajorVersion = 1;
static const int MinorVersion = 0;
static const string Comment = "Kinoko Data-Stream Component";


const char* TKinokoStreamComponent::_StreamTypeName[_NumberOfStreamTypes] = {
    "source",
    "sink",
    "pipe",
    "buffer"
};


TKinokoStreamComponent::TKinokoStreamComponent(const string& TypeName)
: TKinokoComponent(TypeName)
{
    _State = State_Initial;
    _Logger = 0;
}

TKinokoStreamComponent::~TKinokoStreamComponent()
{
    delete _Logger;
}

void TKinokoStreamComponent::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKinokoComponent::BuildDescriptor(Descriptor);

    Descriptor.SetAuthor(Author);
    Descriptor.SetDate(Date);
    Descriptor.SetVersion(MajorVersion, MinorVersion);
    Descriptor.AddComment(Comment);

    Descriptor.RegisterProperty(
	PropertyId_StreamType, TKcomPropertyDeclaration(
	    "stream_type", TKcomPropertyDeclaration::Type_String
	)
    );
    Descriptor.RegisterProperty(
	PropertyId_State, TKcomPropertyDeclaration(
	    "state", TKcomPropertyDeclaration::Type_String
	)
    );

    _Logger = new TKinokoLoggerProxy();
    Descriptor.RegisterImportObject(
    	_Logger, TKcomObjectDeclaration(_Logger->ClassName(), "logger")
    );
}

int TKinokoStreamComponent::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    return TKinokoComponent::ProcessEvent(EventId, Event, EventResponse);
}

int TKinokoStreamComponent::DoTransaction(void) throw(TKcomException)
{
    switch (_State) {
      case State_Shutdown:
	Terminate();
	break;

      default:
	return TKinokoComponent::DoTransaction();
    }

    return 1;
}

void TKinokoStreamComponent::ChangeState(TKinokoStreamComponent::TState State)
{
    _State = State;

    string StateString;
    switch (_State) {
      case State_Initial:
	StateString = "Initial"; 
	break;
      case State_ComponentReady:
	StateString = "ComponentReady"; 
	break;
      case State_Connecting:
	StateString = "Connecting"; 
	break;
      case State_StreamReady:
	StateString = "StreamReady"; 
	break;
      case State_SystemReady:
	StateString = "SystemReady"; 
	break;
      case State_Running:
	StateString = "Running"; 
	break;
      case State_Shutdown:
	StateString = "Shutdown"; 
	break;
      case State_Error:
	StateString = "Error"; 
	break;
      default:
	StateString = "UNKNOWN"; 
    }

    SetProperty(PropertyId_State, StateString);
    _Logger->WriteNotice(ComponentName(), "change state: " + StateString);
}



TKinokoLoggerBufferLogger::TKinokoLoggerBufferLogger(const string& ComponentName, TKinokoLogger* Logger)
{
    _Name = ComponentName;
    _Logger = Logger;
}

TKinokoLoggerBufferLogger::~TKinokoLoggerBufferLogger()
{
}

int TKinokoLoggerBufferLogger::Write(const string& Message, int MessageLevel) throw(TKinokoException)
{
    switch (MessageLevel) {
      case TKinokoBufferLogger::mlInformation:
	_Logger->WriteDebug(_Name, Message); 
	break;
      case TKinokoBufferLogger::mlLog:
	_Logger->WriteNotice(_Name, Message); 
	break;
      case TKinokoBufferLogger::mlWarning:
	_Logger->WriteWarning(_Name, Message); 
	break;
      case TKinokoBufferLogger::mlError:
	_Logger->WriteError(_Name, Message); 
	break;
      case TKinokoBufferLogger::mlPanic:
	_Logger->WritePanic(_Name, Message); 
	break;
      default:
	throw TKinokoException(
	    "TKinokoLoggerBufferLogger::Write()", 
	    "Bad log message level (internal)"
	);
    }   

    return 1;
}
