/* KinokoStreamComponent.hh */
/* Created by Enomoto Sanshiro on 9 October 2000. */
/* Last updated by Enomoto Sanshiro on 27 May 2001. */


#ifndef __KinokoStreamComponent_hh__
#define __KinokoStreamComponent_hh__


#include <string>
#include "KinokoComponent.hh"
#include "KinokoBufferServer.hh"
#include "KinokoLoggerOrb.hh"


class TKinokoStreamComponent: public TKinokoComponent {
  public:
    TKinokoStreamComponent(const std::string& TypeName);
    virtual ~TKinokoStreamComponent();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual int DoTransaction(void) throw(TKcomException);
  protected:
    TKinokoLoggerProxy* _Logger;
  protected:
    enum TEventId {
	_NumberOfEvents = TKinokoComponent::_NumberOfEvents
    };
    enum TPropertyId {
	PropertyId_StreamType = TKinokoComponent::_NumberOfProperties,
	PropertyId_State,
	_NumberOfProperties
    };
    enum TState {
	State_Initial,
	State_ComponentReady,
	State_Connecting,
	State_StreamReady,
	State_SystemReady,
	State_Running,
	State_Shutdown,
	State_Error,
	_NumberOfStates
    };
    enum TStreamType {
	StreamType_Source,
	StreamType_Sink,
	StreamType_Pipe,
	StreamType_Buffer,
	_NumberOfStreamTypes
    };
    static const char* _StreamTypeName[_NumberOfStreamTypes];
  protected:
    TState _State;
    void ChangeState(TState State);
};


class TKinokoLoggerBufferLogger: public TKinokoBufferLogger {
  public:
    TKinokoLoggerBufferLogger(const std::string& ComponentName, TKinokoLogger* Logger);
    virtual ~TKinokoLoggerBufferLogger();
    virtual int Write(const std::string& Message, int MessageLevel) throw(TKinokoException);
  protected:
    std::string _Name;
    TKinokoLogger* _Logger;
};


#endif
