/* KinokoStreamPipeComponent.cc */
/* Created by Enomoto Sanshiro on 22 October 2000. */
/* Last updated by Enomoto Sanshiro on 22 October 2000. */


#include <string>
#include "MushNetworkSocket.hh"
#include "MushDecoratedSocket.hh"
#include "MushTimer.hh"
#include "MushNetworkSocket.hh"
#include "KinokoStream.hh"
#include "KinokoStreamPipeComponent.hh"

using namespace std;


TKinokoStreamPipeComponent::TKinokoStreamPipeComponent(const string& TypeName)
: TKinokoActiveStreamComponent(TypeName)
{
}

TKinokoStreamPipeComponent::~TKinokoStreamPipeComponent()
{
}

void TKinokoStreamPipeComponent::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKinokoActiveStreamComponent::BuildDescriptor(Descriptor);

    TKcomEventDeclaration SetDataSourceNameEvent("setDataSourceName");
    SetDataSourceNameEvent.AddArgument(TKcomPropertyDeclaration(
        "datasource_name", TKcomPropertyDeclaration::Type_String
    ));
    Descriptor.RegisterEventSlot(EventId_SetDataSourceName, SetDataSourceNameEvent);
}

void TKinokoStreamPipeComponent::SetProperties(void) throw(TKinokoException)
{
    SetProperty(PropertyId_StreamType, _StreamTypeName[StreamType_Pipe]);
    SetProperty(PropertyId_Host, TMushNetworkSocket::LocalIPAddress());
    SetLongProperty(PropertyId_PortNumber, 0);
}

int TKinokoStreamPipeComponent::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    int Result = 0;

    switch (EventId) {
      case EventId_SetDataSourceName:
	Result = ProcessSetDataSourceNameEvent(Event);
	break;
	
      default:
	Result = TKinokoActiveStreamComponent::ProcessEvent(
	    EventId, Event, EventResponse
	);
    }

    return Result;
}

int TKinokoStreamPipeComponent::ProcessSetDataSourceNameEvent(TKcomEvent& Event) throw(TKinokoException)
{
    if (Event.ArgumentList().size() < 1) {
	_Logger->WriteError(
	    ComponentName(), "setDataSourceName(): too few arguments"
	);
	return 0;
    }

    _MyDataSourceName = Event.ArgumentList()[0];
    _Logger->WriteDebug(
	ComponentName(), "setDataSourceName(): " + _MyDataSourceName
    );

    return 1;
}
