/* KinokoStreamSourceComponent.cc */
/* Created by Enomoto Sanshiro on 11 October 2000. */
/* Last updated by Enomoto Sanshiro on 11 October 2000. */


#include <string>
#include "KinokoStreamSourceComponent.hh"

using namespace std;


TKinokoStreamSourceComponent::TKinokoStreamSourceComponent(const string& TypeName)
: TKinokoActiveStreamComponent(TypeName)
{
}

TKinokoStreamSourceComponent::~TKinokoStreamSourceComponent()
{
}

void TKinokoStreamSourceComponent::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKinokoActiveStreamComponent::BuildDescriptor(Descriptor);

    TKcomEventDeclaration StartEvent("start");
    Descriptor.RegisterEventSlot(EventId_Start, StartEvent);

    TKcomEventDeclaration StopEvent("stop");
    Descriptor.RegisterEventSlot(EventId_Stop, StopEvent);
}

void TKinokoStreamSourceComponent::SetProperties(void) throw(TKinokoException)
{
    SetProperty(PropertyId_StreamType, _StreamTypeName[StreamType_Source]);
    SetProperty(PropertyId_Host, TMushNetworkSocket::LocalIPAddress());
    SetLongProperty(PropertyId_PortNumber, 0);
}

int TKinokoStreamSourceComponent::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    int Result = 0;

    try {
	switch (EventId) {
	  case EventId_Start:
	    Result = ProcessStartEvent(Event);
	    break;
	    
	  case EventId_Stop:
	    Result = ProcessStopEvent(Event);
	    break;
	
	default:
	    Result = TKinokoActiveStreamComponent::ProcessEvent(
		EventId, Event, EventResponse
	    );
	}
    }
    catch (TKinokoException &e) {
	throw TKcomException(
	    "TKinokoStreamSourceComponent::ProcessEvent()",
	    "kinoko exception: " + e.Message()
	);
    }

    return Result;
}

int TKinokoStreamSourceComponent::ProcessStartEvent(TKcomEvent& Event) throw(TKinokoException)
{
    _Logger->WriteDebug(ComponentName(), "start()");
    StartDataProcessing();

    return 1;
}

int TKinokoStreamSourceComponent::ProcessStopEvent(TKcomEvent& Event) throw(TKinokoException)
{
    _Logger->WriteDebug(ComponentName(), "stop()");
    StopDataProcessing();

    return 1;
}
