/* KinokoViewerCom.hh */
/* Created by Enomoto Sanshiro on 31 October 2000. */
/* Last updated by Enomoto Sanshiro on 24 June 2002. */


#ifndef __KinokoViewerCom_hh__
#define __KinokoViewerCom_hh__


#include <string>
#include "KinokoPlatform.hh"
#include "KinokoViewer.hh"
#include "KinokoStreamSinkComponent.hh"


class TKinokoViewerCom: public TKinokoStreamSinkComponent {
  public:
    TKinokoViewerCom(void);
    virtual ~TKinokoViewerCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual void Initialize(void) throw(TKcomException);
    virtual void Finalize(void) throw(TKcomException);
  protected:
    virtual int ProcessSetViewScriptEvent(TKcomEvent& Event);
    virtual int ProcessResetEvent(TKcomEvent& Event);
    virtual int ProcessExecuteCommandEvent(TKcomEvent& Event);
    virtual int ProcessSaveImageEvent(TKcomEvent& Event);
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void)throw(TKinokoException);
  protected:
    enum TEventId {
	EventId_SetViewScript = TKinokoStreamSinkComponent::_NumberOfEvents,
	EventId_Reset,
	EventId_ExecuteCommand,
	EventId_SaveImage,
	_NumberOfEvents
    };
  protected:
    std::string _ScriptFileName;
    std::string _DisplayEntryName;
    TKinokoEventEmitter* _EventEmitter;
    TKinokoRegistry* _Registry;
    TKinokoViewer* _Viewer;
};


#endif
