/* KinokoControlScript.cc */
/* Created by Enomoto Sanshiro on 22 August 2002. */
/* Last updated by Enomoto Sanshiro on 22 August 2002. */


#include <string>
#include <vector>
#include "KiscScript.hh"
#include "KinokoPlatform.hh"
#include "KinokoControlScript.hh"

using namespace std;


TKinokoControlScript::TKinokoControlScript(TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry)
{
    _EventEmitter = EventEmitter;
    _Registry = Registry;
}

TKinokoControlScript::~TKinokoControlScript()
{
}

TParaTokenTable* TKinokoControlScript::CreateTokenTable(void)
{
    TParaTokenTable* TokenTable = TKiscScript::CreateTokenTable();

    TokenTable->AddKeyword("invoke");

    return TokenTable;
}

TParaOperatorTable* TKinokoControlScript::CreateOperatorTable(void)
{
    return TKiscScript::CreateOperatorTable();
}

TParaStatementTable* TKinokoControlScript::CreateStatementTable(void)
{
    TParaStatementTable* StatementTable;
    StatementTable = TKiscScript::CreateStatementTable();

    StatementTable->AddStatement(
	new TKinokoControlScriptInvokeStatement(_EventEmitter)
    );

    return StatementTable;
}

TParaPackage* TKinokoControlScript::CreatePackage(void)
{
    return TKiscScript::CreatePackage();
}

TParaObjectPrototypeTable* TKinokoControlScript::CreateObjectPrototypeTable(void)
{
    TParaObjectPrototypeTable* ObjectPrototypeTable;
    ObjectPrototypeTable = TKiscScript::CreateObjectPrototypeTable();

    return ObjectPrototypeTable;
}

TParaBuiltinFunctionTable* TKinokoControlScript::CreateBuiltinFunctionTable(void)
{
    TParaBuiltinFunctionTable* FunctionTable;
    FunctionTable = TKiscScript::CreateBuiltinFunctionTable();

    FunctionTable->RegisterAnonymousClass(
	new TKinokoControlSystemMessenger(_Registry)
    );

    return FunctionTable;
}



TKinokoControlSystemMessenger::TKinokoControlSystemMessenger(TKinokoRegistry* Registry)
: TParaObjectPrototype("ControlSystem")
{
    _Registry = Registry;
}

TKinokoControlSystemMessenger::~TKinokoControlSystemMessenger()
{
}

TParaObjectPrototype* TKinokoControlSystemMessenger::Clone(void)
{
    return new TKinokoControlSystemMessenger(_Registry);
}

void TKinokoControlSystemMessenger::Construct(const string& ClassName, vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
}

int TKinokoControlSystemMessenger::DispatchMessage(const string& Message, vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException)
{
    if ((Message == "getRegistry") || (Message == "GetRegistry")) {
        ReturnValue = GetRegistry(ArgumentList);
    }
    else if ((Message == "setRegistry") || (Message == "SetRegistry")) {
        ReturnValue = SetRegistry(ArgumentList);
    }
    else {
	return 0;
    }

    return 1;
}

TParaValue TKinokoControlSystemMessenger::GetRegistry(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (ArgumentList.size() < 1) {
	throw TScriptException(
	    "too few arguments: getRegistry(string registry_path)"
	);
    }
    if (! ArgumentList[0]->IsString()) {
	throw TScriptException(
	    "invalid argument:  getRegistry(string registry_path)"
	);
    }
    string RegistryPath = ArgumentList[0]->AsString();

    string Value = _Registry->GetValue(RegistryPath);

    return TParaValue(Value);
}

TParaValue TKinokoControlSystemMessenger::SetRegistry(vector<TParaValue*>& ArgumentList) throw(TScriptException)
{
    if (ArgumentList.size() < 2) {
	throw TScriptException(
	    "too few argument[s]: "
	    "setRegistry(string registry_path, string value)"
	);
    }
    if (! ArgumentList[0]->IsString()) {
	throw TScriptException(
	    "invalid argument[s]: "
	    "setRegistry(string registry_path, string value)"
	);
    }

    string RegistryPath = ArgumentList[0]->AsString();
    string Value = ArgumentList[1]->AsString();

    _Registry->SetValue(RegistryPath, Value);

    return TParaValue(Value);
}



TKinokoControlScriptInvokeStatement::TKinokoControlScriptInvokeStatement(TKinokoEventEmitter* EventEmitter)
{
    _EventEmitter = EventEmitter;
}

TKinokoControlScriptInvokeStatement::~TKinokoControlScriptInvokeStatement()
{
    for (unsigned i = 0; i < _ArgumentExpressionList.size(); i++) {
	delete _ArgumentExpressionList[i];
    }
}

TParaStatement* TKinokoControlScriptInvokeStatement::Clone(void)
{
    return new TKinokoControlScriptInvokeStatement(_EventEmitter);
}

string TKinokoControlScriptInvokeStatement::FirstToken(void) const
{
    return string("invoke");
}

void TKinokoControlScriptInvokeStatement::Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException)
{
    TParaExpressionParser* ExpressionParser;
    ExpressionParser = StatementParser->ExpressionParser();

    Tokenizer->Next().MustBe(FirstToken());
    TParaToken Token = Tokenizer->Next();

    if (Tokenizer->LookAhead().Is(".")) {
	_TargetName = Token.AsString();
	Tokenizer->Next();
	Token = Tokenizer->Next();
    }

    _EventName = Token.AsString();

    if (Tokenizer->LookAhead().Is("(")) {
	_ArgumentExpressionList = ExpressionParser->ParseExpressionList(
	    Tokenizer, SymbolTable, "(", ")", ","
	);
    }

    Tokenizer->Next().MustBe(";");
}

TParaStatement::TExecResult TKinokoControlScriptInvokeStatement::Execute(TParaSymbolTable* SymbolTable) throw(TScriptException)
{
    vector<string> ArgumentList;
    for (unsigned i = 0; i < _ArgumentExpressionList.size(); i++) {
	ArgumentList.push_back(
	    _ArgumentExpressionList[i]->Evaluate(SymbolTable).AsString()
	);
    }

    TParaStatement::TExecResult Result;
    try {
	if (_TargetName.empty()) {
	    _EventEmitter->EmitEvent(_EventName, ArgumentList);
	}
	else {
	    string ReturnValue;
	    bool IsSuccess = _EventEmitter->EmitEventTo(
		_TargetName, _EventName, ArgumentList, ReturnValue
	    );

	    if (IsSuccess) {
		Result.ReturnValue = TParaValue(ReturnValue);
	    }
	    else {
		throw TScriptException("invoke: " + ReturnValue);
	    }
	}
    }
    catch (TKinokoException &e) {
	throw TScriptException("invoke: " + e.Message());
    }

    return Result;
}
