/* KinokoLoggerOrb.hh */
/* Created by Enomoto Sanshiro on 11 October 2000. */
/* Last updated by Enomoto Sanshiro on 11 October 2000. */


#ifndef __KinokoLoggerOrb_hh__
#define __KinokoLoggerOrb_hh__


#include <string>
#include "KorbOrb.hh"
#include "KorbObjectAdapter.hh"
#include "KorbObjectProxy.hh"
#include "KorbObjectMessenger.hh"
#include "KinokoLogger.hh"


class TKinokoLoggerProxy: public TKorbObjectProxy, public TKinokoLogger {
  public:
    TKinokoLoggerProxy(TKorbOrb* Orb = 0);
    virtual ~TKinokoLoggerProxy();
    virtual int Write(int LogLevel, const std::string& Name, const std::string& Contents);
};



class TKinokoLoggerMessenger: public TKorbObjectMessenger {
  public:
    enum TMethodId {
	MethodId_Write
    };
  public:
    TKinokoLoggerMessenger(TKinokoLogger* Logger);
    virtual ~TKinokoLoggerMessenger();
    virtual int DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:
    TKinokoLogger* _Logger;
};


#endif

