/* KinokoPlatform.hh */
/* Created by Enomoto Sanshiro on 8 July 2001. */
/* Last updated by Enomoto Sanshiro on 18 July 2002. */


#ifndef __KinokoPlatform_hh
#define __KinokoPlatform_hh


#include <string>
#include <vector>
#include "KcomRegistryRepository.hh"
#include "KinokoDefs.hh"


class TKinokoEventEmitter {
  public:
    TKinokoEventEmitter(void);
    virtual ~TKinokoEventEmitter();
    virtual void EmitEvent(const std::string& EventName, const std::vector<std::string>& EventArgumentList) throw(TKinokoException);
    virtual bool EmitEventTo(const std::string& TargetName, const std::string& EventName, const std::vector<std::string>& EventArgumentList, std::string& ReturnValue) throw(TKinokoException);
};


class TKinokoRegistry {
  public:
    TKinokoRegistry(void);
    virtual ~TKinokoRegistry();
    virtual std::string GetValue(const std::string& RegistryPath) = 0;
    virtual void SetValue(const std::string& RegistryPath, const std::string& Value) = 0;
    virtual long GetLongValue(const std::string& RegistryPath) = 0;
    virtual void SetLongValue(const std::string& RegistryPath, long Value) = 0;
};


class TKinokoNullRegistry: public TKinokoRegistry {
  public:
    TKinokoNullRegistry(void);
    virtual ~TKinokoNullRegistry();
    virtual std::string GetValue(const std::string& RegistryPath);
    virtual void SetValue(const std::string& RegistryPath, const std::string& Value);
    virtual long GetLongValue(const std::string& RegistryPath);
    virtual void SetLongValue(const std::string& RegistryPath, long Value);
};


class TKinokoTerminal {
  public:
    TKinokoTerminal(void);
    virtual ~TKinokoTerminal();
    virtual int Put(const std::string& Line) throw(TKcomException) = 0;
    virtual int Get(std::string& Line, char Delimiter = '\n') throw(TKcomException) = 0;
    virtual void SetPrompt(const std::string& Prompt) throw(TKcomException) = 0;
};


class TKinokoNullTerminal: public TKinokoTerminal {
  public:
    TKinokoNullTerminal(void);
    virtual ~TKinokoNullTerminal();
    virtual int Put(const std::string& Line) throw(TKcomException);
    virtual int Get(std::string& Line, char Delimiter = '\n') throw(TKcomException);
    virtual void SetPrompt(const std::string& Prompt) throw(TKcomException);
};


#endif
