/* KinokoReporter.cc */
/* Created by Enomoto Sanshiro on 6 March 2002. */
/* Last updated by Enomoto Sanshiro on 6 March 2001. */


#include <fstream>
#include <string>
#include <vector>
#include "KinokoReporter.hh"

using namespace std;


TKinokoReporter::TKinokoReporter(void)
{
    _OutputFile = 0;
    _NestLevel = 0;
}

TKinokoReporter::~TKinokoReporter()
{
    delete _OutputFile;
}

void TKinokoReporter::Open(const string& FileName)
{
    _OutputFile = new ofstream(FileName.c_str());

    if (! *_OutputFile) {
	delete _OutputFile;
	_OutputFile = 0;
	return;
    }

    *_OutputFile << "<?xml version=\"1.0\"?>" << endl;
    *_OutputFile << endl;
    *_OutputFile << "<report-message>" << endl;

    _NestLevel = 1;
}

void TKinokoReporter::Close(void)
{
    if (_OutputFile) {
	*_OutputFile << "</report-message>" << endl;

	delete _OutputFile;
	_OutputFile = 0;
    }
}

void TKinokoReporter::Write(const string& Name, const string& Contents, const vector<pair<string, string> >& AttributeList)
{
    if (_OutputFile) {
	for (int i = 0; i < _NestLevel; i++) {
	    *_OutputFile << "  ";
	}
	*_OutputFile << "<" << Name;
	for (unsigned j = 0; j < AttributeList.size(); j++) {
	    *_OutputFile << " " << AttributeList[j].first;
	    *_OutputFile << "=\"" << AttributeList[j].second << "\"";
	}
	*_OutputFile << ">";

	for (unsigned k = 0; k < Contents.size(); k++) {
	    char Character = Contents[k];
	    if (Character == '&') {
		*_OutputFile << "&amp;";
	    }
	    else if (Character == '<') {
		*_OutputFile << "&lt;";
	    }
	    else if (Character == '>') {
		*_OutputFile << "&gt;";
	    }
	    else {
		*_OutputFile << Contents[k];
	    }
	}
	*_OutputFile << "</" << Name << ">" << endl;
    }
}
