/* KinokoDataDescriptor.cc */
/* Created by Enomoto Sanshiro on 19 November 2000. */
/* Last updated by Enomoto Sanshiro on 19 November 2000. */


#include <iostream>
#include <string>
#include <map>
#include "ParaTokenizer.hh"
#include "KinokoDataSource.hh"
#include "KinokoDataDescriptor.hh"

using namespace std;


TKinokoDataDescriptor::TKinokoDataDescriptor(void)
{
}

TKinokoDataDescriptor::~TKinokoDataDescriptor()
{
    for (unsigned i = 0; i < _DataSourceList.size(); i++) {
	delete _DataSourceList[i];
    }
}

void TKinokoDataDescriptor::AddDataSource(TKinokoDataSource* DataSource)
{
    _DataSourceList.push_back(DataSource);
    _DataSourceTable[DataSource->DataSourceId()] = DataSource;
    _DataSourceNameTable[DataSource->DataSourceName()] = DataSource;
}

TKinokoDataSource* TKinokoDataDescriptor::DataSource(long DataSourceId)
{
    if (_DataSourceTable.count(DataSourceId) == 0) {
	return 0;
    }

    return _DataSourceTable[DataSourceId];
}

TKinokoDataSource* TKinokoDataDescriptor::DataSource(const string& DataSourceName)
{
    if (_DataSourceNameTable.count(DataSourceName) == 0) {
	return 0;
    }

    return _DataSourceNameTable[DataSourceName];
}

const vector<TKinokoDataSource*>& TKinokoDataDescriptor::DataSourceList(void)
{
    return _DataSourceList;
}

void TKinokoDataDescriptor::ReadFrom(istream& is) throw(TKinokoException)
{
    TParaCxxTokenTable TokenTable;
    TParaTokenizer Tokenizer(is, &TokenTable);

    while (! Tokenizer.LookAhead().IsEmpty()) {
	string DataSourceName;
	long DataSourceId;
	try {
	    Tokenizer.Next().MustBe("datasource");
	    DataSourceName = Tokenizer.Next().RemoveQuotation().AsString();
	    Tokenizer.Next().MustBe("<");
	    DataSourceId = Tokenizer.Next().AsLong();
	    Tokenizer.Next().MustBe(">");
	}
	catch (TScriptException &e) {
	    throw TKinokoException(
		"TKinokoDataDescriptor::ReadFrom()",
		"script exception: " + e.Message()
	    );
	}
	
	TKinokoDataSource* DataSource = 0;
	try {
	    DataSource = new TKinokoDataSource(DataSourceName, DataSourceId);
	    DataSource->ReadFrom(Tokenizer);
	}
	catch (TKinokoException &e) {
	    delete DataSource;
	    throw TKinokoException(
		"TKinokoDataDescriptor::ReadFrom()", e.Message()
	    );
	}
	
	AddDataSource(DataSource);
    }
}

void TKinokoDataDescriptor::WriteTo(ostream& os)
{
    for (unsigned i = 0; i < _DataSourceList.size(); i++) {
	_DataSourceList[i]->WriteTo(os);
	os << endl;
    }
}
