/* KinokoDataSection.cc */
/* Created by Enomoto Sanshiro on 19 November 2000. */
/* Last updated by Enomoto Sanshiro on 19 November 2000. */


#include <iostream>
#include <string>
#include "ParaTokenizer.hh"
#include "KinokoDataSource.hh"
#include "KinokoDataSection.hh"

#include "KinokoNestedDataSection.hh"
#include "KinokoTaggedDataSection.hh"
#include "KinokoIndexedDataSection.hh"
#include "KinokoBlockDataSection.hh"

using namespace std;


int TKinokoDataSection::AutomaticSectionIdAssignmentBase(void)
{
    return 256;
}

TKinokoDataSection::TKinokoDataSection(TKinokoDataSource* DataSource, const string& SectionName)
{
    _DataSource = DataSource;
    _SectionName = SectionName;

    _SectionId = SectionId_Unknown;
    _Parent = 0;
}

TKinokoDataSection::TKinokoDataSection(TKinokoDataSource* DataSource, const string& SectionName, int SectionId)
{
    _DataSource = DataSource;
    _SectionName = SectionName;

    _SectionId = SectionId;
    _Parent = 0;
}

TKinokoDataSection::~TKinokoDataSection()
{
}

void TKinokoDataSection::SetSectionId(int SectionId)
{
    _SectionId = SectionId;
}

void TKinokoDataSection::SetParent(TKinokoDataSection* Parent)
{
    _Parent = Parent;
}

string TKinokoDataSection::SectionNameOf(const string& SectionPath)
{
    int Length = SectionPath.find_first_of(':');
    string SectionName = SectionPath.substr(0, Length);

    return SectionName;
}

string TKinokoDataSection::SubSectionPathOf(const string& SectionPath)
{
    string SubSectionPath = SectionPath;
    int Length = SubSectionPath.find_first_of(':');
    SubSectionPath.erase(0, Length + 1);

    return SubSectionPath;
}



TKinokoDataSectionFactory* TKinokoDataSectionFactory::_Instance = 0;

TKinokoDataSectionFactory::TKinokoDataSectionFactory(void)
{
}

TKinokoDataSectionFactory::~TKinokoDataSectionFactory()
{
}

TKinokoDataSectionFactory* TKinokoDataSectionFactory::GetInstance(void)
{
    if (_Instance == 0) {
	_Instance = new TKinokoDataSectionFactory();
    }

    return _Instance;
}

TKinokoDataSection* TKinokoDataSectionFactory::ReadFrom(TParaTokenizer& Tokenizer, TKinokoDataSource* DataSource) throw(TKinokoException)
{
    string DataSectionName;
    long DataSectionId;
    string DataSectionType;
    try {
	Tokenizer.Next().MustBe("section");
	DataSectionName = Tokenizer.Next().RemoveQuotation().AsString();
	Tokenizer.Next().MustBe("<");
	DataSectionId = Tokenizer.Next().AsLong();
	Tokenizer.Next().MustBe(">");
	Tokenizer.Next().MustBe(":");
	DataSectionType = Tokenizer.Next().AsString();
    }
    catch (TScriptException &e) {
	throw TKinokoException(
	    "TKinokoDataSectionFactory::ReadFrom()",
	    "script exception: " + e.Message()
	);
    }
	
    TKinokoDataSection* DataSection = 0;
    if (DataSectionType == "nested") {
	DataSection = new TKinokoNestedDataSection(
	    DataSource, DataSectionName, DataSectionId
	);
    }
    else if (DataSectionType == "tagged") {
	DataSection = new TKinokoTaggedDataSection(
	    DataSource, DataSectionName, DataSectionId
	);
    }
    else if (DataSectionType == "indexed") {
	DataSection = new TKinokoIndexedDataSection(
	    DataSource, DataSectionName, DataSectionId
	);
    }
    else if (DataSectionType == "block") {
	DataSection = new TKinokoBlockDataSection(
	    DataSource, DataSectionName, DataSectionId
	);
    }
    else {
	throw TKinokoException(
	    "TKinokoDataSectionFactory::ReadFrom()",
	    "unknown data section type: " + DataSectionType
	);
    }
    
    try {
	DataSection->ReadFrom(Tokenizer);
    }
    catch (TKinokoException &e) {
	delete DataSection;
	throw TKinokoException(
	    "TKinokoDataSectionFactory::ReadFrom()",
	    e.Message()
	);
    }

    return DataSection;
}



TKinokoDataSectionFormatter::TKinokoDataSectionFormatter(TKinokoDataSection* DataSection) throw(TKinokoException)
{
    _DataSourceId = DataSection->DataSource()->DataSourceId();
    _SectionId = DataSection->SectionId();
    
    if (_SectionId == 0) {
	throw TKinokoException(
	    "TKinokoDataSectionFormatter::TKinokoDataSectionFormatter()",
	    "invalid section ID (internal): " + DataSection->FullSectionName()
	);
    }
}

TKinokoDataSectionFormatter::~TKinokoDataSectionFormatter()
{
}



TKinokoDataSectionScanner::TKinokoDataSectionScanner(void)
{
}

TKinokoDataSectionScanner::~TKinokoDataSectionScanner()
{
}
