/* KinokoDataSectionContainer.cc */
/* Created by Enomoto Sanshiro on 25 January 2002. */
/* Last updated by Enomoto Sanshiro on 25 January 2002. */


#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "ParaTokenizer.hh"
#include "KinokoDataSection.hh"
#include "KinokoDataSectionContainer.hh"

using namespace std;



TKinokoDataSectionContainer::TKinokoDataSectionContainer(void)
{
    _NextSectionId = TKinokoDataSection::AutomaticSectionIdAssignmentBase();
}

TKinokoDataSectionContainer::~TKinokoDataSectionContainer()
{
    for (unsigned i = 0; i < _DataSectionList.size(); i++) {
	delete _DataSectionList[i];
    }
}

void TKinokoDataSectionContainer::AddDataSection(TKinokoDataSection* DataSection)
{
    string SectionName = DataSection->SectionName();
    int SectionId = DataSection->SectionId();

    if (_DataSectionNameTable.count(SectionName) == 0) {
	if (SectionId == TKinokoDataSection::SectionId_Unknown) {
	    SectionId = _NextSectionId++;
	    DataSection->SetSectionId(SectionId);
	}

	_DataSectionTable[SectionId] = DataSection;
	_DataSectionNameTable[SectionName] = DataSection;    
	_DataSectionList.push_back(DataSection);
    }
    else if (SectionId == TKinokoDataSection::SectionId_Unknown) {
	SectionId = _DataSectionNameTable[SectionName]->SectionId();
	DataSection->SetSectionId(SectionId);
    }
}
