/* KinokoDataSectionContainer.hh */
/* Created by Enomoto Sanshiro on 25 January 2002. */
/* Last updated by Enomoto Sanshiro on 25 January 2002. */


#ifndef __KinokoDataSectionContainer_hh__
#define __KinokoDataSectionContainer_hh__


#include <string>
#include <vector>
#include <map>
#include "KinokoDataSection.hh"


class TKinokoDataSectionContainer {
  public:
    TKinokoDataSectionContainer(void);
    virtual ~TKinokoDataSectionContainer();
    virtual void AddDataSection(TKinokoDataSection* DataSection);
    inline TKinokoDataSection* DataSection(int SectionId);
    inline TKinokoDataSection* DataSection(const std::string& SectionName);
  protected:
    int _NextSectionId;
    std::vector<TKinokoDataSection*> _DataSectionList;
    std::map<long, TKinokoDataSection*> _DataSectionTable;
    std::map<std::string, TKinokoDataSection*> _DataSectionNameTable;
};


inline TKinokoDataSection* TKinokoDataSectionContainer::DataSection(int SectionId)
{
    if (_DataSectionTable.count(SectionId) == 0) {
	return 0;
    }

    return _DataSectionTable[SectionId];
}

inline TKinokoDataSection* TKinokoDataSectionContainer::DataSection(const std::string& SectionName)
{
    if (_DataSectionNameTable.count(SectionName) == 0) {
	return 0;
    }

    return _DataSectionNameTable[SectionName];
}

#endif
