/* KinokoDataSource.hh */
/* Created by Enomoto Sanshiro on 19 November 2000. */
/* Last updated by Enomoto Sanshiro on 25 January 2002. */


#ifndef __KinokoDataSource_hh__
#define __KinokoDataSource_hh__


#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "ParaTokenizer.hh"
#include "KinokoDataSection.hh"
#include "KinokoDataSectionContainer.hh"


class TKinokoDataSource: public TKinokoDataSectionContainer {
  public:
    TKinokoDataSource(const std::string& DataSourceName, long DataSourceId);
    virtual ~TKinokoDataSource();
    inline long DataSourceId(void) const;
    inline const std::string& DataSourceName(void) const;
    virtual void SetName(const std::string& DataSourceName, long DataSourceId);
    virtual void AddAttribute(const std::string& Name, const std::string& Value);
    bool GetAttributeOf(const std::string& Name, std::string& Value);
    virtual void ReadFrom(TParaTokenizer& Tokenizer) throw(TKinokoException);
    virtual void WriteTo(std::ostream& os);
    static int AutomaticDataSourceIdAssignmentBase(void);
  protected:
    void ParseAttribute(TParaTokenizer& Tokenizer) throw(TKinokoException);
    void ParseSection(TParaTokenizer& Tokenizer) throw(TKinokoException);
  protected:
    long _DataSourceId;
    std::string _DataSourceName;
    std::vector<std::pair<std::string, std::string> > _AttributeList;
  public:
    enum TSpecialDataSourceId {
	DataSourceId_Null = 0,
	DataSourceId_Any = -1,
	DataSourceId_Unknown = -2,
	_NumberOfSpecialDataSourceIds
    };
};


inline long TKinokoDataSource::DataSourceId(void) const
{
    return _DataSourceId;
}

inline const std::string& TKinokoDataSource::DataSourceName(void) const
{
    return _DataSourceName;
}


#endif
