/* KinokoDataStreamFormatter.cc */
/* Created by Enomoto Sanshiro on 23 November 2000. */
/* Last updated by Enomoto Sanshiro on 23 November 2000. */


#include <strstream>
#include "MushDataEncoder.hh"
#include "KinokoDataSource.hh"
#include "KinokoDataStreamFormatter.hh"

using namespace std;


TKinokoDataStreamFormatter::TKinokoDataStreamFormatter(TKinokoDataSource* DataSource)
{
    _DataSource = DataSource;
    _DataSourceId = DataSource->DataSourceId();

    _DescriptorLength = 0;
}

TKinokoDataStreamFormatter::~TKinokoDataStreamFormatter()
{
}

int TKinokoDataStreamFormatter::DescriptorPacketSize(void)
{
    //... temporary ...//
    if (_DescriptorLength == 0) {
	ostrstream DescriptorStream;
	_DataSource->WriteTo(DescriptorStream);
	DescriptorStream << ends;

	_DescriptorLength = (DescriptorStream.pcount() / 4 + 1) * 4;
    }

    return sizeof(U32bit) * Offset_Contents + _DescriptorLength;
}

void TKinokoDataStreamFormatter::WriteDescriptor(void* Buffer)
{
    if (_DescriptorLength == 0) {
	return;
    }

    ((U32bit*) Buffer)[Offset_DataSourceId] = _DataSourceId & DataSourceIdMask;
    ((U32bit*) Buffer)[Offset_PacketType] = PacketType_DataDescriptor;

    char* Base = (char*) ((U32bit*) Buffer + Offset_Contents);
    ostrstream BufferStream(Base, _DescriptorLength);

    _DataSource->WriteTo(BufferStream);
    BufferStream << ends;
}



TMushBinaryDataEncoder* TKinokoDataStreamScanner::_DataEncoder = 0;

TKinokoDataStreamScanner::TKinokoDataStreamScanner(void)
{
}

TKinokoDataStreamScanner::~TKinokoDataStreamScanner()
{
}

void TKinokoDataStreamScanner::CorrectByteOrder(void* Buffer, int BufferSize)
{
    if (! IsByteOrderReversed(Buffer)) {
	return;
    }

    if (_DataEncoder == 0) {
	_DataEncoder = new TMushBinaryDataEncoder(sizeof(U32bit), true);
    }

    int HeaderSize = Offset_Contents * sizeof(U32bit);
    _DataEncoder->DecodeOn(Buffer, HeaderSize);
    
    if (IsDataPacket(Buffer)) {
	void* Contents = ((U32bit*) Buffer) + Offset_Contents;
	_DataEncoder->DecodeOn(Contents, BufferSize - HeaderSize);
    }
}



TKinokoStreamCommandProcessor::TKinokoStreamCommandProcessor(void)
{
    _NumberOfRunningDataSources = 0;
    _NumberOfSuspendingDataSources = 0;
}

TKinokoStreamCommandProcessor::~TKinokoStreamCommandProcessor()
{
}

void TKinokoStreamCommandProcessor::ProcessCommand(int CommandValue)
{
    if (CommandValue == TKinokoDataStreamScanner::Command_RunBegin) {
        _NumberOfRunningDataSources++;
	OnReceiveRunBeginPacket();
	if (_NumberOfRunningDataSources == 1) {
	    OnReceiveFirstRunBeginPacket();
	}
    }
    else if (CommandValue == TKinokoDataStreamScanner::Command_RunEnd) {
        _NumberOfRunningDataSources--;
	OnReceiveRunEndPacket();
	if (_NumberOfRunningDataSources == 0) {
	    OnReceiveLastRunEndPacket();
	}
    }
    else if (CommandValue == TKinokoDataStreamScanner::Command_RunSuspend) {
        _NumberOfSuspendingDataSources++;
	OnReceiveRunSuspendPacket();
	if (_NumberOfSuspendingDataSources == _NumberOfRunningDataSources) {
	    OnReceiveLastRunSuspendPacket();
	}
    }
    else if (CommandValue == TKinokoDataStreamScanner::Command_RunResume) {
        _NumberOfSuspendingDataSources--;
	OnReceiveRunResumePacket();
	if (_NumberOfSuspendingDataSources == _NumberOfRunningDataSources - 1) {
	    OnReceiveFirstRunResumePacket();
	}
    }
}
