/* KinokoIndexedDataSection.cc */
/* Created by Enomoto Sanshiro on 19 November 2000. */
/* Last updated by Enomoto Sanshiro on 19 November 2000. */


#include <iostream>
#include <string>
#include "ParaTokenizer.hh"
#include "KinokoDataSource.hh"
#include "KinokoDataSection.hh"
#include "KinokoIndexedDataSection.hh"

using namespace std;


TKinokoIndexedDataSection::TKinokoIndexedDataSection(TKinokoDataSource* DataSource, const string& SectionName)
: TKinokoDataSection(DataSource, SectionName)
{
    _AddressWidth = 0;
    _DataWidth = 0;

    _Formatter = 0;
    _Scanner = 0;
}

TKinokoIndexedDataSection::TKinokoIndexedDataSection(TKinokoDataSource* DataSource, const string& SectionName, int SectionId)
: TKinokoDataSection(DataSource, SectionName, SectionId)
{
    _AddressWidth = 0;
    _DataWidth = 0;

    _Formatter = 0;
    _Scanner = 0;
}

TKinokoIndexedDataSection::~TKinokoIndexedDataSection()
{
    delete _Formatter;
    delete _Scanner;
}

void TKinokoIndexedDataSection::SetWidth(int AddressWidth, int DataWidth)
{
    _AddressWidth = AddressWidth;
    _DataWidth = DataWidth;
}

int TKinokoIndexedDataSection::AddressWidth(void) const
{
    return _AddressWidth;
}

int TKinokoIndexedDataSection::DataWidth(void) const
{
    return _DataWidth;
}

int TKinokoIndexedDataSection::SectionType(void) const
{
    return TKinokoDataSection::SectionType_Indexed;
}

void TKinokoIndexedDataSection::ReadFrom(TParaTokenizer& Tokenizer) throw(TKinokoException)
{
    int AddressWidth, DataWidth;
    try {
	Tokenizer.Next().MustBe("(");
	Tokenizer.Next().MustBe("address");
	Tokenizer.Next().MustBe(":");
	Tokenizer.Next().MustBe("int");
	Tokenizer.Next().MustBe("-");
	AddressWidth = Tokenizer.Next().AsLong();
	Tokenizer.Next().MustBe("bit");
	Tokenizer.Next().MustBe(",");
	Tokenizer.Next().MustBe("data");
	Tokenizer.Next().MustBe(":");
	Tokenizer.Next().MustBe("int");
	Tokenizer.Next().MustBe("-");
	DataWidth = Tokenizer.Next().AsLong();
	Tokenizer.Next().MustBe("bit");
	Tokenizer.Next().MustBe(")");
	Tokenizer.Next().MustBe(";");
    }
    catch (TScriptException &e) {
	throw TKinokoException(
	    "TKinokoIndexedDataSection::ReadFrom()",
	    "script exception: " + e.Message()
	);
    }

    SetWidth(AddressWidth, DataWidth);
}

void TKinokoIndexedDataSection::WriteTo(ostream& os, const string& Indent)
{
    os << Indent << "section \"" << _SectionName << "\"<" << _SectionId << ">";
    os << ": indexed(address: int-" << _AddressWidth << "bit, ";
    os << "data: int-" << _DataWidth << "bit);" << endl;
}



TKinokoIndexedDataSectionFormatter::TKinokoIndexedDataSectionFormatter(TKinokoIndexedDataSection* DataSection)
: TKinokoDataSectionFormatter(DataSection)
{
    _AddressWidth = DataSection->AddressWidth();
    _DataWidth = DataSection->DataWidth();

    _UsesTwoWords = (_AddressWidth + _DataWidth > 32);
}

TKinokoIndexedDataSectionFormatter::~TKinokoIndexedDataSectionFormatter()
{
}



TKinokoIndexedDataSectionScanner::TKinokoIndexedDataSectionScanner(TKinokoIndexedDataSection* DataSection)
{
    _AddressWidth = DataSection->AddressWidth();
    _DataWidth = DataSection->DataWidth();
    
    _UsesTwoWords = (_AddressWidth + _DataWidth > 32);

    _DataBitMask = 0;
    for (int Bit = 0; Bit < _DataWidth; Bit++) {
	_DataBitMask |= 0x0001 << Bit;
    }
}

TKinokoIndexedDataSectionScanner::~TKinokoIndexedDataSectionScanner()
{
}
